/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.asm;

import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.kingdoms.asm.Event;
import org.kingdoms.asm.EventExecutor;
import org.kingdoms.asm.Listener;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.w3c.dom.events.EventException;

public class StaticMethodHandleEventExecutor
implements EventExecutor {
    private final Class<? extends Event> eventClass;
    private final MethodHandle handle;

    public StaticMethodHandleEventExecutor(@NotNull Class<? extends Event> eventClass, @NotNull Method m) {
        Preconditions.checkArgument((boolean)Modifier.isStatic(m.getModifiers()), (String)"Not a static method: %s", (Object)m);
        Preconditions.checkArgument((eventClass != null ? 1 : 0) != 0, (Object)"eventClass is null");
        this.eventClass = eventClass;
        try {
            m.setAccessible(true);
            this.handle = MethodHandles.lookup().unreflect(m);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("Unable to set accessible", e);
        }
    }

    @Override
    public void execute(@NotNull Listener listener, @NotNull Event event) throws EventException {
        if (!this.eventClass.isInstance(event)) {
            return;
        }
        try {
            this.handle.invoke(event);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

