/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.addons;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.kingdoms.addons.Addon;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;

public final class AddonRegistry {
    private static final Map<String, Addon> ADDONS = new HashMap<String, Addon>(5);

    public static Addon getAddon(String name) {
        return ADDONS.get(name);
    }

    public static void unregister(Addon addon) {
        Objects.requireNonNull(addon, "Cannot unregister null addon");
        if (ADDONS.remove(addon.getAddonName()) == null) {
            throw new IllegalArgumentException("Addon '" + addon.getName() + "' wasn't enabled/registered");
        }
    }

    public static @Unmodifiable @NotNull Map<String, Addon> getAddons() {
        return Collections.unmodifiableMap(ADDONS);
    }

    public static void uninstall(Addon addon, boolean updating) {
        Objects.requireNonNull(addon, "Cannot uninstall null addon");
        if (!updating) {
            addon.uninstall();
        }
        Bukkit.getPluginManager().disablePlugin((Plugin)addon);
        ADDONS.remove(addon.getAddonName());
        File file = addon.getFile();
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
            KLogger.info("Deleting addon file: " + file);
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }, 20L);
    }

    public static void register(Addon addon) {
        Objects.requireNonNull(addon, "Addon instance cannot be null");
        if (ADDONS.containsKey(addon.getAddonName())) {
            throw new IllegalArgumentException("An addon with that name already exists: " + addon.getName());
        }
        ADDONS.put(addon.getAddonName(), addon);
        Bukkit.getServicesManager().register(addon.getClass(), (Object)addon, (Plugin)Kingdoms.get(), ServicePriority.Normal);
    }
}

