/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.reflection.proxy;

import com.cryptomorin.xseries.reflection.proxy.OverloadedMethod;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ClassOverloadedMethods<T> {
    private final Map<String, OverloadedMethod<T>> mapped;

    public ClassOverloadedMethods(Map<String, OverloadedMethod<T>> mapped) {
        this.mapped = mapped;
    }

    public Map<String, OverloadedMethod<T>> mappings() {
        return this.mapped;
    }

    public T get(String name, Supplier<String> descriptor) {
        return this.get(name, descriptor, false);
    }

    public T get(String name, Supplier<String> descriptor, boolean ignoreIfNull) {
        OverloadedMethod<T> overloads = this.mapped.get(name);
        if (overloads == null) {
            if (ignoreIfNull) {
                return null;
            }
            throw new IllegalArgumentException("Failed to find any method named '" + name + "' with descriptor '" + descriptor.get() + "' " + this);
        }
        T overload = overloads.get(descriptor);
        if (overload == null) {
            if (ignoreIfNull) {
                return null;
            }
            throw new IllegalArgumentException("Failed to find overloaded method named '" + name + " with descriptor: '" + descriptor.get() + "' " + this);
        }
        return overload;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.mapped + ')';
    }
}

