/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.messages;

import com.cryptomorin.xseries.reflection.XReflection;
import com.cryptomorin.xseries.reflection.minecraft.MinecraftClassHandle;
import com.cryptomorin.xseries.reflection.minecraft.MinecraftConnection;
import com.cryptomorin.xseries.reflection.minecraft.MinecraftPackage;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Titles {
    private static final Object TITLE_ACTION_TITLE;
    private static final Object TITLE_ACTION_SUBTITLE;
    private static final Object TITLE_ACTION_TIMES;
    private static final Object TITLE_ACTION_CLEAR;
    private static final MethodHandle PACKET_PLAY_OUT_TITLE;
    private static final MethodHandle CHAT_COMPONENT_TEXT;
    private String title;
    private String subtitle;
    private final int fadeIn;
    private final int stay;
    private final int fadeOut;
    private static final boolean SUPPORTS_TITLES;

    public Titles(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        this.title = title;
        this.subtitle = subtitle;
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }

    public Titles copy() {
        return new Titles(this.title, this.subtitle, this.fadeIn, this.stay, this.fadeOut);
    }

    public void send(Player player) {
        Titles.sendTitle(player, this.fadeIn, this.stay, this.fadeOut, this.title, this.subtitle);
    }

    public static void sendTitle(@NotNull Player player, int fadeIn, int stay, int fadeOut, @Nullable String title, @Nullable String subtitle) {
        Objects.requireNonNull(player, "Cannot send title to null player");
        if (title == null && subtitle == null) {
            return;
        }
        if (SUPPORTS_TITLES) {
            player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
            return;
        }
        try {
            Object timesPacket = PACKET_PLAY_OUT_TITLE.invoke(TITLE_ACTION_TIMES, CHAT_COMPONENT_TEXT.invoke(title), fadeIn, stay, fadeOut);
            MinecraftConnection.sendPacket(player, timesPacket);
            if (title != null) {
                Object titlePacket = PACKET_PLAY_OUT_TITLE.invoke(TITLE_ACTION_TITLE, CHAT_COMPONENT_TEXT.invoke(title), fadeIn, stay, fadeOut);
                MinecraftConnection.sendPacket(player, titlePacket);
            }
            if (subtitle != null) {
                Object subtitlePacket = PACKET_PLAY_OUT_TITLE.invoke(TITLE_ACTION_SUBTITLE, CHAT_COMPONENT_TEXT.invoke(subtitle), fadeIn, stay, fadeOut);
                MinecraftConnection.sendPacket(player, subtitlePacket);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void sendTitle(@NotNull Player player, @NotNull String title, @NotNull String subtitle) {
        Titles.sendTitle(player, 10, 20, 10, title, subtitle);
    }

    public static Titles sendTitle(@NotNull Player player, @NotNull ConfigurationSection config) {
        Titles titles = Titles.parseTitle(config, null);
        titles.send(player);
        return titles;
    }

    public static Titles parseTitle(@NotNull ConfigurationSection config) {
        return Titles.parseTitle(config, null);
    }

    public static Titles parseTitle(@NotNull ConfigurationSection config, @Nullable Function<String, String> transformers) {
        String title = config.getString("title");
        String subtitle = config.getString("subtitle");
        if (transformers != null) {
            title = transformers.apply(title);
            subtitle = transformers.apply(subtitle);
        }
        int fadeIn = config.getInt("fade-in");
        int stay = config.getInt("stay");
        int fadeOut = config.getInt("fade-out");
        if (fadeIn < 1) {
            fadeIn = 10;
        }
        if (stay < 1) {
            stay = 20;
        }
        if (fadeOut < 1) {
            fadeOut = 10;
        }
        return new Titles(title, subtitle, fadeIn, stay, fadeOut);
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public static void clearTitle(@NotNull Player player) {
        Object clearPacket;
        Objects.requireNonNull(player, "Cannot clear title from null player");
        if (XReflection.supports(11)) {
            player.resetTitle();
            return;
        }
        try {
            clearPacket = PACKET_PLAY_OUT_TITLE.invoke(TITLE_ACTION_CLEAR, null, -1, -1, -1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        MinecraftConnection.sendPacket(player, clearPacket);
    }

    public static void sendTabList(@NotNull String header, @NotNull String footer, Player ... players) {
        Objects.requireNonNull(players, "Cannot send tab title to null players");
        Objects.requireNonNull(header, "Tab title header cannot be null");
        Objects.requireNonNull(footer, "Tab title footer cannot be null");
        if (XReflection.supports(13)) {
            for (Player player : players) {
                player.setPlayerListHeaderFooter(header, footer);
            }
            return;
        }
        try {
            Class IChatBaseComponent = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.chat").named("IChatBaseComponent").unreflect();
            Class PacketPlayOutPlayerListHeaderFooter = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").named("PacketPlayOutPlayerListHeaderFooter").unreflect();
            Method chatComponentBuilderMethod = IChatBaseComponent.getDeclaredClasses()[0].getMethod("a", String.class);
            Object tabHeader = chatComponentBuilderMethod.invoke(null, "{\"text\":\"" + header + "\"}");
            Object tabFooter = chatComponentBuilderMethod.invoke(null, "{\"text\":\"" + footer + "\"}");
            Object packet = PacketPlayOutPlayerListHeaderFooter.getConstructor(new Class[0]).newInstance(new Object[0]);
            Field headerField = PacketPlayOutPlayerListHeaderFooter.getDeclaredField("a");
            Field footerField = PacketPlayOutPlayerListHeaderFooter.getDeclaredField("b");
            headerField.setAccessible(true);
            headerField.set(packet, tabHeader);
            footerField.setAccessible(true);
            footerField.set(packet, tabFooter);
            for (Player player : players) {
                MinecraftConnection.sendPacket(player, packet);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to send tablist: " + header + " - " + footer, ex);
        }
    }

    static {
        boolean SUPPORTS_TITLES1;
        MethodHandle packetCtor = null;
        MethodHandle chatComp = null;
        Object times = null;
        Object title = null;
        Object subtitle = null;
        Object clear = null;
        try {
            Player.class.getDeclaredMethod("sendTitle", String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            SUPPORTS_TITLES1 = true;
        }
        catch (NoSuchMethodException e) {
            SUPPORTS_TITLES1 = false;
        }
        SUPPORTS_TITLES = SUPPORTS_TITLES1;
        if (!SUPPORTS_TITLES) {
            MinecraftClassHandle chatComponentText = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS).named("ChatComponentText");
            MinecraftClassHandle packet = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS).named("PacketPlayOutTitle");
            MinecraftClassHandle IChatBaseComponentClass = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS).named("IChatBaseComponent");
            Class<?> titleTypes = ((Class)packet.unreflect()).getDeclaredClasses()[0];
            block16: for (Object type : titleTypes.getEnumConstants()) {
                switch (type.toString()) {
                    case "TIMES": {
                        times = type;
                        continue block16;
                    }
                    case "TITLE": {
                        title = type;
                        continue block16;
                    }
                    case "SUBTITLE": {
                        subtitle = type;
                        continue block16;
                    }
                    case "CLEAR": {
                        clear = type;
                    }
                }
            }
            try {
                chatComp = chatComponentText.constructor(String.class).reflect();
                packetCtor = packet.constructor(titleTypes, (Class)IChatBaseComponentClass.unreflect(), Integer.TYPE, Integer.TYPE, Integer.TYPE).reflect();
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
        TITLE_ACTION_TITLE = title;
        TITLE_ACTION_SUBTITLE = subtitle;
        TITLE_ACTION_TIMES = times;
        TITLE_ACTION_CLEAR = clear;
        PACKET_PLAY_OUT_TITLE = packetCtor;
        CHAT_COMPONENT_TEXT = chatComp;
    }
}

