/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter;

import com.fastasyncworldedit.bukkit.FaweBukkit;
import com.fastasyncworldedit.bukkit.adapter.IBukkitAdapter;
import com.fastasyncworldedit.bukkit.adapter.NMSRelighterFactory;
import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.extent.processor.PlacementStateProcessor;
import com.fastasyncworldedit.core.extent.processor.lighting.RelighterFactory;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.implementation.packet.ChunkPacket;
import com.sk89q.jnbt.LinBusConverter;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinTag;

public interface BukkitImplAdapter<T>
extends IBukkitAdapter {
    @Nullable
    public DataFixer getDataFixer();

    default public boolean supportsWatchdog() {
        return false;
    }

    default public void tickWatchdog() {
    }

    public BlockState getBlock(Location var1);

    public BaseBlock getFullBlock(Location var1);

    public WorldNativeAccess<?, ?, ?> createWorldNativeAccess(World var1);

    @Nullable
    public BaseEntity getEntity(Entity var1);

    @Nullable
    public Entity createEntity(Location var1, BaseEntity var2);

    public Component getRichBlockName(BlockType var1);

    public Component getRichItemName(ItemType var1);

    public Component getRichItemName(BaseItemStack var1);

    public Map<String, ? extends Property<?>> getProperties(BlockType var1);

    public void sendFakeNBT(Player var1, BlockVector3 var2, LinCompoundTag var3);

    public void sendFakeOP(Player var1);

    default public boolean simulateItemUse(World world, BlockVector3 position, BaseItem item, Direction face) {
        return false;
    }

    public boolean canPlaceAt(World var1, BlockVector3 var2, BlockState var3);

    @Override
    public ItemStack adapt(BaseItemStack var1);

    @Override
    public BaseItemStack adapt(ItemStack var1);

    public Set<SideEffect> getSupportedSideEffects();

    default public OptionalInt getInternalBlockStateId(BlockData data) {
        return this.getInternalBlockStateId(BukkitAdapter.adapt(data));
    }

    default public OptionalInt getInternalBlockStateId(BlockState state) {
        return OptionalInt.empty();
    }

    default public boolean regenerate(World world, Region region, Extent extent, RegenOptions options) throws Exception {
        throw new UnsupportedOperationException("This adapter does not support regeneration.");
    }

    default public boolean clearContainerBlockContents(World world, BlockVector3 pt) {
        throw new UnsupportedOperationException("This adapter does not support clearing block contents.");
    }

    default public void setBiome(Location location, BiomeType biome) {
        throw new UnsupportedOperationException("This adapter does not support custom biomes.");
    }

    default public BiomeType getBiome(Location location) {
        throw new UnsupportedOperationException("This adapter does not support custom biomes.");
    }

    default public void initializeRegistries() {
    }

    default public void sendBiomeUpdates(World world, Iterable<BlockVector2> chunks) {
    }

    default public BlockMaterial getMaterial(BlockType blockType) {
        return this.getMaterial(blockType.getDefaultState());
    }

    default public BlockMaterial getMaterial(BlockState blockState) {
        return null;
    }

    default public Collection<String> getRegisteredDefaultBlockStates() {
        ArrayList<String> blocks = new ArrayList<String>();
        for (Material m : Material.values()) {
            if (m.isLegacy() || !m.isBlock()) continue;
            BlockData blockData = m.createBlockData();
            blocks.add(blockData.getAsString());
        }
        return blocks;
    }

    @Deprecated
    default public Tag toNative(T foreign) {
        return LinBusConverter.toJnbtTag(this.toNativeLin(foreign));
    }

    default public LinTag<?> toNativeLin(T foreign) {
        return this.toNative(foreign).toLinTag();
    }

    @Deprecated
    default public T fromNative(Tag foreign) {
        if (foreign == null) {
            return null;
        }
        return this.fromNativeLin(foreign.toLinTag());
    }

    default public T fromNativeLin(LinTag<?> foreign) {
        if (foreign == null) {
            return null;
        }
        return this.fromNative(LinBusConverter.toJnbtTag(foreign));
    }

    @Nullable
    default public World createWorld(WorldCreator creator) {
        return ((FaweBukkit)Fawe.platform()).createWorldUnloaded(() -> ((WorldCreator)creator).createWorld());
    }

    default public void sendFakeChunk(World world, Player player, ChunkPacket packet) {
        throw new UnsupportedOperationException("Cannot send fake chunks");
    }

    default public IChunkGet get(World world, int chunkX, int chunkZ) {
        throw new UnsupportedOperationException();
    }

    default public int getInternalBiomeId(BiomeType biome) {
        return Biome.BADLANDS.ordinal();
    }

    default public Iterable<NamespacedKey> getRegisteredBiomes() {
        return Arrays.stream(Biome.values()).map(Keyed::getKey).collect(Collectors.toList());
    }

    default public RelighterFactory getRelighterFactory() {
        return new NMSRelighterFactory();
    }

    default public Map<String, List<Property<?>>> getAllProperties() {
        return Collections.emptyMap();
    }

    default public IBatchProcessor getTickingPostProcessor() {
        return null;
    }

    default public PlacementStateProcessor getPlatformPlacementProcessor(Extent extent, BlockTypeMask mask, Region region) {
        return null;
    }
}

