/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.adapter;

import com.fastasyncworldedit.core.extent.processor.lighting.NMSRelighter;
import com.fastasyncworldedit.core.extent.processor.lighting.Relighter;
import com.fastasyncworldedit.core.queue.IQueueExtent;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.TaskManager;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class StarlightRelighter<SERVER_LEVEL, CHUNK_POS>
implements Relighter {
    protected static final Logger LOGGER = LogManagerCompat.getLogger();
    private static final int CHUNKS_PER_BATCH = 1024;
    private static final int CHUNKS_PER_BATCH_SQRT_LOG2 = 5;
    private final ReentrantLock lock = new ReentrantLock();
    private final Long2ObjectLinkedOpenHashMap<LongSet> regions = new Long2ObjectLinkedOpenHashMap();
    private final ReentrantLock areaLock = new ReentrantLock();
    private final NMSRelighter delegate;
    protected final SERVER_LEVEL serverLevel;

    protected StarlightRelighter(SERVER_LEVEL serverLevel, IQueueExtent<?> queue) {
        this.serverLevel = serverLevel;
        this.delegate = new NMSRelighter(queue);
    }

    protected Set<CHUNK_POS> convertChunkKeysToChunkPos(LongSet chunks) {
        HashSet<CHUNK_POS> coords = new HashSet<CHUNK_POS>();
        LongIterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            coords.add(this.createChunkPos(iterator.nextLong()));
        }
        return coords;
    }

    protected abstract CHUNK_POS createChunkPos(long var1);

    protected abstract long asLong(int var1, int var2);

    protected abstract CompletableFuture<?> chunkLoadFuture(CHUNK_POS var1);

    protected List<CompletableFuture<?>> chunkLoadFutures(Set<CHUNK_POS> coords) {
        ArrayList futures = new ArrayList();
        for (CHUNK_POS coord : coords) {
            futures.add(this.chunkLoadFuture(coord));
        }
        return futures;
    }

    @NotNull
    protected IntConsumer postProcessCallback(Runnable andThen, Set<CHUNK_POS> coords) {
        return i -> {
            if (i != coords.size()) {
                LOGGER.warn("Processed {} chunks instead of {}", (Object)i, (Object)coords.size());
            }
            TaskManager.taskManager().task(() -> this.postProcessChunks(coords));
            TaskManager.taskManager().async(andThen);
        };
    }

    protected abstract void invokeRelight(Set<CHUNK_POS> var1, Consumer<CHUNK_POS> var2, IntConsumer var3);

    protected abstract void postProcessChunks(Set<CHUNK_POS> var1);

    protected void fixLighting(LongSet chunks, Runnable andThen) {
        Set<CHUNK_POS> coords = this.convertChunkKeysToChunkPos(chunks);
        TaskManager.taskManager().task(() -> {
            List<CompletableFuture<?>> futures = this.chunkLoadFutures(coords);
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenAccept(v -> this.invokeRelight(coords, c -> {}, this.postProcessCallback(andThen, coords)));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChunk(int cx, int cz, byte[] skipReason, int bitmask) {
        this.areaLock.lock();
        try {
            long key = MathMan.pairInt((int)(cx >> 5), (int)(cz >> 5));
            LongSet chunks = (LongSet)this.regions.computeIfAbsent(key, k -> new LongArraySet(256));
            chunks.add(this.asLong(cx, cz));
        }
        finally {
            this.areaLock.unlock();
        }
        return true;
    }

    public void fixLightingSafe(boolean sky) {
        this.areaLock.lock();
        try {
            if (this.regions.isEmpty()) {
                return;
            }
            LongSet first = (LongSet)this.regions.removeFirst();
            this.fixLighting(first, () -> this.fixLightingSafe(true));
        }
        finally {
            this.areaLock.unlock();
        }
    }

    public void addLightUpdate(int x, int y, int z) {
        this.delegate.addLightUpdate(x, y, z);
    }

    public void clear() {
    }

    public void removeLighting() {
        this.delegate.removeLighting();
    }

    public void fixBlockLighting() {
        this.fixLightingSafe(true);
    }

    public void fixSkyLighting() {
        this.fixLightingSafe(true);
    }

    public boolean isEmpty() {
        return true;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public boolean isFinished() {
        return false;
    }

    public void close() throws Exception {
        this.fixLightingSafe(true);
    }
}

