/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.api.objects;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public enum Language {
    ENGLISH("English", Arrays.asList("en_gb", "en_nz", "en_us", "en_ca")),
    FRENCH("French", Collections.singletonList("fr_fr")),
    ITALIAN("Italian", Collections.singletonList("it_it")),
    SPANISH("Spanish", Collections.singletonList("es_es")),
    PIRATE("Pirate", Collections.singletonList("en_pt"));

    private final String name;
    private final List<String> locale;

    public static Language getLanguageFromClientLocale(String clientLocale) {
        return Arrays.stream(Language.values()).filter(language -> language.getLocale().contains(clientLocale)).findFirst().orElse(null);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getLocale() {
        return this.locale;
    }

    @Generated
    private Language(String name, List<String> locale) {
        this.name = name;
        this.locale = locale;
    }
}

