/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.api.interfaces.database;

import com.conaxgames.api.ICorePlayer;
import com.conaxgames.api.interfaces.IPunishment;
import com.conaxgames.api.interfaces.IScope;
import com.conaxgames.api.interfaces.managers.IChatTagManager;
import com.conaxgames.api.objects.Language;
import com.conaxgames.api.objects.OfflineWarn;
import com.conaxgames.api.objects.Pair;
import com.conaxgames.api.objects.Scope;
import com.conaxgames.api.objects.StaffHistoryPunishment;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bukkit.command.CommandSender;

public interface Connection {
    public void closeConnection();

    public MongoDatabase getDatabase();

    public MongoCollection<Document> getProfilesCollection();

    public MongoCollection<Document> getChatTagsCollection();

    public MongoCollection<Document> getPunishmentsCollection();

    public MongoCollection<Document> getGuildsCollection();

    public MongoCollection<Document> getGuildInvitesCollection();

    public MongoCollection<Document> getGuildMembersCollection();

    public MongoCollection<Document> getGrantsCollection();

    public MongoCollection<Document> getRanksCollection();

    public MongoCollection<Document> getAuditCollection();

    public MongoCollection<Document> getNetworkCollection();

    public MongoCollection<Document> getDisguiseRankCollection();

    public MongoCollection<Document> getDisguiseProfilesCollection();

    public MongoCollection<Scope> getScopesCollection();

    public CompletableFuture<Boolean> profileAlreadyExists(UUID var1);

    public CompletableFuture<Boolean> profileAlreadyExists(String var1);

    public CompletableFuture<Boolean> createProfile(Bson var1, UUID var2, String var3);

    public CompletableFuture<ICorePlayer> loadProfile(Bson var1, Boolean var2, ICorePlayer var3);

    public CompletableFuture<Document> getProfileDocument(Bson var1);

    public CompletableFuture<UUID> getUuid(String var1);

    public CompletableFuture<String> getName(UUID var1);

    public CompletableFuture<Boolean> addGrant(UUID var1, String var2, String var3);

    public CompletableFuture<Boolean> removeGrant(UUID var1, String var2);

    public CompletableFuture<Boolean> setSocials(UUID var1, Map<String, String> var2);

    public CompletableFuture<Map<String, String>> getSocials(UUID var1);

    public CompletableFuture<Boolean> incrementFilterSpam(UUID var1, Integer var2);

    public CompletableFuture<Boolean> incrementFilterToxicity(UUID var1, Integer var2);

    public CompletableFuture<Boolean> setUnlockedChatTags(UUID var1, String var2);

    public CompletableFuture<Boolean> setUnlockedTagColors(UUID var1, String var2);

    public CompletableFuture<Boolean> setUnlockedNameColors(UUID var1, String var2);

    public CompletableFuture<Boolean> unsetActiveChatTag(UUID var1);

    public CompletableFuture<Boolean> setNetworkXP(UUID var1, Integer var2);

    public CompletableFuture<Boolean> addNetworkXP(UUID var1, Integer var2);

    public CompletableFuture<Boolean> setScopedPermissions(UUID var1, HashMap<String, Map<String, Long>> var2);

    public CompletableFuture<Boolean> setLanguage(UUID var1, Language var2);

    public CompletableFuture<Boolean> unsetNickname(UUID var1);

    public CompletableFuture<Boolean> unsetCustomTagColor(UUID var1);

    public CompletableFuture<Boolean> setCustomColor(UUID var1, String var2);

    public CompletableFuture<Boolean> unsetCustomColor(UUID var1);

    public CompletableFuture<List<OfflineWarn>> loadOfflineWarnings(UUID var1);

    public CompletableFuture<Boolean> addIgnoring(UUID var1, String var2);

    public CompletableFuture<Boolean> removeIgnoring(UUID var1, String var2);

    public CompletableFuture<Boolean> addFriend(UUID var1, String var2);

    public CompletableFuture<Boolean> removeFriend(UUID var1, String var2);

    public CompletableFuture<Boolean> setCurrency(UUID var1, String var2, Integer var3);

    public CompletableFuture<Boolean> setMute(UUID var1, String var2);

    public CompletableFuture<Boolean> unsetMute(UUID var1);

    public CompletableFuture<Boolean> setBan(UUID var1, String var2);

    public CompletableFuture<Boolean> unsetBan(UUID var1);

    public CompletableFuture<Boolean> setBlacklist(UUID var1, String var2);

    public CompletableFuture<Boolean> unsetBlacklist(UUID var1);

    public CompletableFuture<Boolean> setIPBan(UUID var1, String var2);

    public CompletableFuture<Boolean> unsetIPBan(UUID var1);

    public CompletableFuture<Boolean> setOfflineWarnings(UUID var1, String var2);

    public CompletableFuture<Boolean> unsetOfflineWarnings(UUID var1);

    public CompletableFuture<Boolean> setVanished(UUID var1, Boolean var2);

    public CompletableFuture<Boolean> setStaffMode(UUID var1, Boolean var2);

    public CompletableFuture<Boolean> setGlobalChatToggle(UUID var1, Boolean var2);

    public CompletableFuture<Boolean> setPrivateMessageToggle(UUID var1, Boolean var2);

    public CompletableFuture<Boolean> setStaffMessagesToggle(UUID var1, Boolean var2);

    public CompletableFuture<Boolean> setSoundsToggle(UUID var1, Boolean var2);

    public CompletableFuture<Boolean> setAutoBroadcastsToggle(UUID var1, Boolean var2);

    public CompletableFuture<Boolean> setAutoBroadcastSoundsToggle(UUID var1, Boolean var2);

    public CompletableFuture<Boolean> setAcceptingPaymentsToggle(UUID var1, Boolean var2);

    public CompletableFuture<Boolean> setAcceptingTeleportsToggle(UUID var1, Boolean var2);

    public CompletableFuture<Boolean> setSocialSpyToggle(UUID var1, Boolean var2);

    public CompletableFuture<Boolean> setToggle(UUID var1, String var2, Boolean var3);

    public CompletableFuture<Boolean> setNickname(UUID var1, String var2);

    public CompletableFuture<Boolean> setElement(UUID var1, Boolean var2);

    public CompletableFuture<Boolean> unsetElement(UUID var1);

    public CompletableFuture<Boolean> setWorldTime(UUID var1, String var2);

    public CompletableFuture<Boolean> setOfflineRank(UUID var1, String var2);

    public CompletableFuture<Boolean> onLogin(UUID var1, String var2, String var3, Long var4);

    public CompletableFuture<Boolean> onLogout(UUID var1, Long var2, HashMap<String, Long> var3, Long var4);

    public CompletableFuture<Pair<Boolean, Long>> setDisguise(UUID var1, String var2, String var3, String var4);

    public CompletableFuture<Boolean> unsetDisguise(UUID var1);

    public void loadChatTags(IChatTagManager var1);

    public CompletableFuture<Boolean> createDefaultTags(IChatTagManager var1);

    public void setActiveChatTag(UUID var1, String var2);

    public void setCustomTagColor(UUID var1, String var2);

    public void createChatTag(Document var1);

    public CompletableFuture<Boolean> deleteChatTag(Bson var1);

    public CompletableFuture<Document> getChatTag(String var1);

    public CompletableFuture<Boolean> chatTagAlreadyExists(String var1);

    public CompletableFuture<Boolean> updateChatTag(Bson var1, Bson var2);

    public void createScope(Scope var1);

    public CompletableFuture<Boolean> deleteScope(Bson var1);

    public CompletableFuture<IScope> getScope(String var1);

    public CompletableFuture<Boolean> scopeAlreadyExists(String var1);

    public CompletableFuture<List<IPunishment>> loadPunishments(UUID var1);

    public CompletableFuture<List<StaffHistoryPunishment>> loadStaffHistory(UUID var1);

    public void audit(UUID var1, String var2, String var3, List<Pair<String, Object>> var4);

    public CompletableFuture<Document> getNetworkConfigDocument();

    public CompletableFuture<Boolean> updateNetworkConfig(CommandSender var1, Field var2, String var3);
}

