/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.xseries.reflection.jvm;

import com.conaxgames.libraries.xseries.reflection.XReflection;
import com.conaxgames.libraries.xseries.reflection.jvm.FlaggedNamedMemberHandle;
import com.conaxgames.libraries.xseries.reflection.jvm.MethodMemberHandle;
import com.conaxgames.libraries.xseries.reflection.jvm.classes.ClassHandle;
import com.conaxgames.libraries.xseries.reflection.jvm.classes.DynamicClassHandle;
import com.conaxgames.libraries.xseries.reflection.minecraft.MinecraftMapping;
import com.conaxgames.libraries.xseries.reflection.parser.ReflectionParser;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.intellij.lang.annotations.Pattern;

public class FieldMemberHandle
extends FlaggedNamedMemberHandle {
    public static final MethodHandle MODIFIERS_FIELD;
    public static final DynamicClassHandle VarHandle;
    public static final MethodHandle VAR_HANDLE_SET;
    private static final Object MODIFIERS_VAR_HANDLE;
    protected Boolean getter;

    public FieldMemberHandle(ClassHandle clazz) {
        super(clazz);
    }

    public FieldMemberHandle getter() {
        this.getter = true;
        return this;
    }

    @Override
    public FieldMemberHandle asStatic() {
        super.asStatic();
        return this;
    }

    public FieldMemberHandle asFinal() {
        this.isFinal = true;
        return this;
    }

    @Override
    public FieldMemberHandle makeAccessible() {
        super.makeAccessible();
        return this;
    }

    public FieldMemberHandle setter() {
        this.getter = false;
        return this;
    }

    @Override
    public FieldMemberHandle returns(Class<?> clazz) {
        super.returns(clazz);
        return this;
    }

    @Override
    public FieldMemberHandle returns(ClassHandle clazz) {
        super.returns(clazz);
        return this;
    }

    @Override
    public FieldMemberHandle clone() {
        FieldMemberHandle handle = new FieldMemberHandle(this.clazz);
        handle.returnType = this.returnType;
        handle.getter = this.getter;
        handle.isFinal = this.isFinal;
        handle.makeAccessible = this.makeAccessible;
        handle.names.addAll(this.names);
        return handle;
    }

    @Override
    public MethodHandle reflect() throws ReflectiveOperationException {
        Objects.requireNonNull(this.getter, "Not specified whether the method is a getter or setter");
        Field jvm = this.reflectJvm();
        if (this.getter.booleanValue()) {
            return this.clazz.getNamespace().getLookup().unreflectGetter(jvm);
        }
        return this.clazz.getNamespace().getLookup().unreflectSetter(jvm);
    }

    @Override
    public boolean exists() {
        try {
            this.reflectJvm();
            return true;
        }
        catch (ReflectiveOperationException ignored) {
            return false;
        }
    }

    @Override
    public FieldMemberHandle signature(String declaration) {
        return new ReflectionParser(declaration).imports(this.clazz.getNamespace()).parseField(this);
    }

    @Override
    public FieldMemberHandle map(MinecraftMapping mapping, @Pattern(value="\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*") String name) {
        super.map(mapping, name);
        return this;
    }

    @Override
    public FieldMemberHandle named(String ... names) {
        super.named(names);
        return this;
    }

    @Override
    protected <T extends AccessibleObject> T handleAccessible(T field) throws ReflectiveOperationException {
        block6: {
            if ((field = super.handleAccessible(field)) == null) {
                return null;
            }
            if (this.getter != null && !this.getter.booleanValue() && this.isFinal && this.isStatic) {
                try {
                    int unfinalModifiers = ((Member)((Object)field)).getModifiers() & 0xFFFFFFEF;
                    if (MODIFIERS_VAR_HANDLE != null) {
                        VAR_HANDLE_SET.invoke(MODIFIERS_VAR_HANDLE, field, unfinalModifiers);
                        break block6;
                    }
                    if (MODIFIERS_FIELD != null) {
                        MODIFIERS_FIELD.invoke(field, unfinalModifiers);
                        break block6;
                    }
                    throw new IllegalAccessException("Current Java version doesn't support modifying final fields. " + this);
                }
                catch (Throwable e) {
                    throw new ReflectiveOperationException("Cannot unfinal field " + this, e);
                }
            }
        }
        return field;
    }

    public Field reflectJvm() throws ReflectiveOperationException {
        Objects.requireNonNull(this.returnType, "Return type not specified");
        if (this.names.isEmpty()) {
            throw new IllegalStateException("No names specified");
        }
        Throwable errors = null;
        Field field = null;
        Class clazz = (Class)this.clazz.reflect();
        Class<?> returnType = this.getReturnType();
        for (String name : this.names) {
            if (field != null) break;
            try {
                field = clazz.getDeclaredField(name);
                if (field.getType() != returnType) {
                    throw new NoSuchFieldException("Field named '" + name + "' was found but the types don't match: " + field + " != " + this);
                }
                if (!this.isFinal || Modifier.isFinal(field.getModifiers())) continue;
                throw new NoSuchFieldException("Field named '" + name + "' was found but it's not final: " + field + " != " + this);
            }
            catch (NoSuchFieldException ex) {
                field = null;
                if (errors == null) {
                    errors = new NoSuchFieldException("None of the fields were found for " + this);
                }
                errors.addSuppressed(ex);
            }
        }
        if (field == null) {
            throw (NoSuchFieldException)XReflection.relativizeSuppressedExceptions(errors);
        }
        return this.handleAccessible(field);
    }

    public String toString() {
        String str = this.getClass().getSimpleName() + '{';
        if (this.makeAccessible) {
            str = str + "protected/private ";
        }
        if (this.isFinal) {
            str = str + "final ";
        }
        if (this.returnType != null) {
            str = str + this.returnType + " ";
        }
        str = str + String.join((CharSequence)"/", this.names);
        return str + '}';
    }

    static {
        VarHandle = XReflection.classHandle().inPackage("java.lang.invoke").named("VarHandle");
        VAR_HANDLE_SET = (MethodHandle)((MethodMemberHandle)VarHandle.method().named("set").returns((Class)Void.TYPE)).parameters(Object[].class).reflectOrNull();
        Object modVarHandle = null;
        MethodHandle modifierFieldJvm = null;
        try {
            modifierFieldJvm = (MethodHandle)XReflection.of(Field.class).field().setter().named("modifiers").returns((Class)Integer.TYPE).unreflect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            VarHandle.reflect();
            MethodHandle PRIVATE_LOOKUP_IN = ((MethodMemberHandle)XReflection.of(MethodHandles.class).method().named("privateLookupIn").returns((Class)MethodHandles.Lookup.class)).parameters(Class.class, MethodHandles.Lookup.class).reflect();
            MethodHandle FIND_VAR_HANDLE = ((MethodMemberHandle)VarHandle.method().named("findVarHandle").returns((Class)MethodHandles.Lookup.class)).parameters(Class.class, String.class, Class.class).reflect();
            MethodHandles.Lookup lookup = PRIVATE_LOOKUP_IN.invoke(Field.class, MethodHandles.lookup());
            FIND_VAR_HANDLE.invoke(lookup, Field.class, "modifiers", Integer.TYPE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MODIFIERS_VAR_HANDLE = modVarHandle;
        MODIFIERS_FIELD = modifierFieldJvm;
    }
}

