/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.xseries.reflection.jvm;

import com.conaxgames.libraries.xseries.reflection.XReflection;
import com.conaxgames.libraries.xseries.reflection.jvm.MemberHandle;
import com.conaxgames.libraries.xseries.reflection.jvm.NamedMemberHandle;
import com.conaxgames.libraries.xseries.reflection.jvm.classes.ClassHandle;
import com.conaxgames.libraries.xseries.reflection.minecraft.MinecraftMapping;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumMemberHandle
extends NamedMemberHandle {
    public EnumMemberHandle(ClassHandle clazz) {
        super(clazz);
    }

    @Override
    public EnumMemberHandle map(MinecraftMapping mapping, @Pattern(value="\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*") String name) {
        super.map(mapping, name);
        return this;
    }

    @Override
    public EnumMemberHandle named(String ... names) {
        super.named(names);
        return this;
    }

    @Override
    @ApiStatus.Obsolete
    public MemberHandle signature(String declaration) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    @ApiStatus.Obsolete
    public MethodHandle unreflect() {
        return (MethodHandle)super.unreflect();
    }

    @Override
    @ApiStatus.Obsolete
    @Nullable
    public MethodHandle reflectOrNull() {
        return (MethodHandle)super.reflectOrNull();
    }

    @Override
    @ApiStatus.Obsolete
    public MethodHandle reflect() throws ReflectiveOperationException {
        Field jvm = this.reflectJvm();
        return this.clazz.getNamespace().getLookup().unreflectGetter(jvm);
    }

    @Nullable
    public Object getEnumConstant() {
        try {
            return this.reflectJvm().get(null);
        }
        catch (ReflectiveOperationException ex) {
            throw XReflection.throwCheckedException(ex);
        }
    }

    public Field reflectJvm() throws ReflectiveOperationException {
        if (this.names.isEmpty()) {
            throw new IllegalStateException("No enum names specified");
        }
        Throwable errors = null;
        Field field = null;
        Class clazz = (Class)this.clazz.reflect();
        for (String name : this.names) {
            if (field != null) break;
            try {
                field = clazz.getDeclaredField(name);
                if (field.isEnumConstant()) continue;
                throw new NoSuchFieldException("Field named '" + name + "' was found but it's not an enum constant " + this);
            }
            catch (NoSuchFieldException ex) {
                field = null;
                if (errors == null) {
                    errors = new NoSuchFieldException("None of the enums were found for " + this);
                }
                errors.addSuppressed(ex);
            }
        }
        if (field == null) {
            throw (NoSuchFieldException)XReflection.relativizeSuppressedExceptions(errors);
        }
        return this.handleAccessible(field);
    }

    @Override
    @ApiStatus.Obsolete
    public EnumMemberHandle clone() {
        throw new UnsupportedOperationException();
    }
}

