/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.xseries.profiles.builder;

import com.conaxgames.libraries.xseries.profiles.ProfileLogger;
import com.conaxgames.libraries.xseries.profiles.builder.ProfileFallback;
import com.conaxgames.libraries.xseries.profiles.builder.XSkull;
import com.conaxgames.libraries.xseries.profiles.exceptions.InvalidProfileException;
import com.conaxgames.libraries.xseries.profiles.exceptions.ProfileChangeException;
import com.conaxgames.libraries.xseries.profiles.exceptions.ProfileException;
import com.conaxgames.libraries.xseries.profiles.mojang.PlayerProfileFetcherThread;
import com.conaxgames.libraries.xseries.profiles.mojang.ProfileRequestConfiguration;
import com.conaxgames.libraries.xseries.profiles.objects.DelegateProfileable;
import com.conaxgames.libraries.xseries.profiles.objects.ProfileContainer;
import com.conaxgames.libraries.xseries.profiles.objects.Profileable;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProfileInstruction<T>
implements DelegateProfileable {
    private final ProfileContainer<T> profileContainer;
    private Profileable profileable;
    private final List<Profileable> fallbacks = new ArrayList<Profileable>();
    private Consumer<ProfileFallback<T>> onFallback;
    private ProfileRequestConfiguration profileRequestConfiguration;
    private boolean lenient = false;

    protected ProfileInstruction(ProfileContainer<T> profileContainer) {
        this.profileContainer = profileContainer;
    }

    public T removeProfile() {
        this.profileContainer.setProfile(null);
        return this.profileContainer.getObject();
    }

    @ApiStatus.Experimental
    public ProfileInstruction<T> profileRequestConfiguration(ProfileRequestConfiguration config) {
        this.profileRequestConfiguration = config;
        return this;
    }

    public ProfileInstruction<T> lenient() {
        this.lenient = true;
        return this;
    }

    @Override
    @Nullable
    public GameProfile getProfile() {
        return this.profileContainer.getProfile();
    }

    @Override
    public Profileable getDelegateProfile() {
        return this.profileContainer;
    }

    public ProfileInstruction<T> profile(@NotNull Profileable profileable) {
        this.profileable = Objects.requireNonNull(profileable, "Profileable is null");
        return this;
    }

    public ProfileInstruction<T> fallback(Profileable ... fallbacks) {
        Objects.requireNonNull(fallbacks, "fallbacks array is null");
        this.fallbacks.addAll(Arrays.asList(fallbacks));
        return this;
    }

    public ProfileInstruction<T> onFallback(@Nullable Consumer<ProfileFallback<T>> onFallback) {
        this.onFallback = onFallback;
        return this;
    }

    public ProfileInstruction<T> onFallback(@NotNull Runnable onFallback) {
        Objects.requireNonNull(onFallback, "onFallback runnable is null");
        this.onFallback = fallback -> onFallback.run();
        return this;
    }

    public T apply() {
        Objects.requireNonNull(this.profileable, "No profile was set");
        Throwable exception = null;
        ArrayList<Profileable> tries = new ArrayList<Profileable>(2 + this.fallbacks.size());
        tries.add(this.profileable);
        tries.addAll(this.fallbacks);
        if (this.lenient) {
            tries.add(XSkull.getDefaultProfile());
        }
        boolean success = false;
        boolean tryingFallbacks = false;
        for (Profileable profileable : tries) {
            try {
                GameProfile gameProfile = profileable.getDisposableProfile();
                if (gameProfile != null) {
                    this.profileContainer.setProfile(gameProfile);
                    success = true;
                    break;
                }
                if (exception == null) {
                    exception = new ProfileChangeException("Could not set the profile for " + this.profileContainer);
                }
                exception.addSuppressed(new InvalidProfileException(profileable.toString(), "Profile doesn't have a value: " + profileable));
                tryingFallbacks = true;
            }
            catch (ProfileException ex) {
                if (exception == null) {
                    exception = new ProfileChangeException("Could not set the profile for " + this.profileContainer);
                }
                exception.addSuppressed(ex);
                tryingFallbacks = true;
            }
        }
        if (exception != null) {
            if (success || this.lenient) {
                ProfileLogger.debug("apply() silenced exception {}", exception);
            } else {
                throw exception;
            }
        }
        T object = this.profileContainer.getObject();
        if (tryingFallbacks && this.onFallback != null) {
            ProfileFallback<T> fallback = new ProfileFallback<T>(this, object, (ProfileChangeException)exception);
            this.onFallback.accept(fallback);
            object = fallback.getObject();
        }
        return object;
    }

    public CompletableFuture<T> applyAsync() {
        return CompletableFuture.supplyAsync(this::apply, PlayerProfileFetcherThread.EXECUTOR);
    }
}

