/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.xseries.messages;

import com.conaxgames.libraries.xseries.reflection.XReflection;
import com.conaxgames.libraries.xseries.reflection.minecraft.MinecraftConnection;
import com.conaxgames.libraries.xseries.reflection.minecraft.MinecraftPackage;
import com.google.common.base.Strings;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionBar {
    private static final boolean USE_SPIGOT_API = XReflection.supports(12);
    private static final MethodHandle CHAT_COMPONENT_TEXT;
    private static final MethodHandle PACKET_PLAY_OUT_CHAT;
    private static final Object CHAT_MESSAGE_TYPE;
    private static final char TIME_SPECIFIER_START = '^';
    private static final char TIME_SPECIFIER_END = '|';

    private ActionBar() {
    }

    public static void sendActionBar(@NotNull Plugin plugin, @NotNull Player player, @Nullable String message) {
        int end;
        if (!Strings.isNullOrEmpty((String)message) && message.charAt(0) == '^' && (end = message.indexOf(124)) != -1) {
            int time = 0;
            try {
                time = Integer.parseInt(message.substring(1, end)) * 20;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (time >= 0) {
                ActionBar.sendActionBar(plugin, player, message.substring(end + 1), time);
            }
        }
        ActionBar.sendActionBar(player, message);
    }

    public static void sendActionBar(@NotNull Player player, @Nullable String message) {
        Objects.requireNonNull(player, "Cannot send action bar to null player");
        Objects.requireNonNull(message, "Cannot send null actionbar message");
        if (USE_SPIGOT_API) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
            return;
        }
        try {
            Object component = CHAT_COMPONENT_TEXT.invoke("{\"text\":\"" + message.replace("\\", "\\\\").replace("\"", "\\\"") + "\"}");
            Object packet = PACKET_PLAY_OUT_CHAT.invoke(component, CHAT_MESSAGE_TYPE);
            MinecraftConnection.sendPacket(player, packet);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void sendActionBar(@NotNull Plugin plugin, final @NotNull Player player, final @Nullable String message, final long duration) {
        if (duration < 1L) {
            return;
        }
        Objects.requireNonNull(plugin, "Cannot send consistent actionbar with null plugin");
        Objects.requireNonNull(player, "Cannot send actionbar to null player");
        Objects.requireNonNull(message, "Cannot send null actionbar message");
        new BukkitRunnable(){
            long repeater;
            {
                this.repeater = duration;
            }

            public void run() {
                ActionBar.sendActionBar(player, message);
                this.repeater -= 40L;
                if (this.repeater - 40L < -20L) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously(plugin, 0L, 40L);
    }

    public static void sendPlayersActionBar(@Nullable String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ActionBar.sendActionBar(player, message);
        }
    }

    public static void clearActionBar(@NotNull Player player) {
        ActionBar.sendActionBar(player, " ");
    }

    public static void clearPlayersActionBar() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ActionBar.clearActionBar(player);
        }
    }

    public static void sendActionBarWhile(@NotNull Plugin plugin, final @NotNull Player player, final @Nullable String message, final @NotNull Callable<Boolean> callable) {
        new BukkitRunnable(){

            public void run() {
                try {
                    if (!((Boolean)callable.call()).booleanValue()) {
                        this.cancel();
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ActionBar.sendActionBar(player, message);
            }
        }.runTaskTimerAsynchronously(plugin, 0L, 40L);
    }

    public static void sendActionBarWhile(@NotNull Plugin plugin, final @NotNull Player player, final @Nullable Callable<String> message, final @NotNull Callable<Boolean> callable) {
        new BukkitRunnable(){

            public void run() {
                try {
                    if (!((Boolean)callable.call()).booleanValue()) {
                        this.cancel();
                        return;
                    }
                    ActionBar.sendActionBar(player, (String)message.call());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.runTaskTimerAsynchronously(plugin, 0L, 40L);
    }

    static {
        MethodHandle packet = null;
        MethodHandle chatComp = null;
        Byte chatMsgType = null;
        if (!USE_SPIGOT_API) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class packetPlayOutChatClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").named("PacketPlayOutChat").unreflect();
            Class iChatBaseComponentClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.chat").named("IChatBaseComponent").unreflect();
            Class ChatSerializerClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.chat").named("IChatBaseComponent$ChatSerializer").unreflect();
            try {
                chatComp = lookup.findStatic(ChatSerializerClass, "a", MethodType.methodType(iChatBaseComponentClass, String.class));
                Class<?> chatMessageTypeClass = Class.forName(XReflection.NMS_PACKAGE + XReflection.v(17, "network.chat").orElse("") + "ChatMessageType");
                MethodType type = MethodType.methodType(Void.TYPE, iChatBaseComponentClass, chatMessageTypeClass);
                for (Object obj : chatMessageTypeClass.getEnumConstants()) {
                    String name = obj.toString();
                    if (!name.equals("GAME_INFO") && !name.equalsIgnoreCase("ACTION_BAR")) continue;
                    chatMsgType = obj;
                    break;
                }
                packet = lookup.findConstructor(packetPlayOutChatClass, type);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ignored) {
                try {
                    chatMsgType = 2;
                    packet = lookup.findConstructor(packetPlayOutChatClass, MethodType.methodType(Void.TYPE, iChatBaseComponentClass, Byte.TYPE));
                }
                catch (IllegalAccessException | NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
            }
        }
        CHAT_MESSAGE_TYPE = chatMsgType;
        CHAT_COMPONENT_TEXT = chatComp;
        PACKET_PLAY_OUT_CHAT = packet;
    }
}

