/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.xseries.base;

import com.conaxgames.libraries.xseries.base.XModule;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class XRegistry<XForm extends XModule<XForm, BukkitForm>, BukkitForm>
implements Iterable<XForm> {
    private static final boolean PERFORM_AUTO_ADD = true;
    private final Map<String, XForm> nameMappings = new HashMap<String, XForm>(20);
    private final Map<BukkitForm, XForm> bukkitToX = new IdentityHashMap<BukkitForm, XForm>(20);
    private final Class<BukkitForm> bukkitFormClass;
    private final Class<XForm> xFormClass;
    private final Supplier<Object> registrySupplier;
    private final BiFunction<BukkitForm, String[], XForm> creator;
    private final Function<Integer, XForm[]> createArray;
    private final String registryName;
    private final boolean supportsRegistry;
    private final boolean isEnum;
    private boolean pulled = false;

    public XRegistry(Class<BukkitForm> bukkitFormClass, Class<XForm> xFormClass, Supplier<Object> registrySupplier, BiFunction<BukkitForm, String[], XForm> creator, Function<Integer, XForm[]> createArray) {
        boolean supported;
        try {
            registrySupplier.get();
            supported = true;
        }
        catch (Throwable ex) {
            supported = false;
        }
        this.bukkitFormClass = bukkitFormClass;
        this.xFormClass = xFormClass;
        this.registryName = this.bukkitFormClass.getSimpleName();
        this.registrySupplier = registrySupplier;
        this.createArray = createArray;
        this.creator = creator;
        this.supportsRegistry = supported;
        this.isEnum = bukkitFormClass.isEnum();
        if (!this.supportsRegistry && !this.isEnum) {
            throw new IllegalStateException("Bukkit form is neither an enum nor a registry " + bukkitFormClass);
        }
    }

    public Map<String, XForm> nameMapping() {
        return this.nameMappings;
    }

    public Map<BukkitForm, XForm> mapping() {
        return this.bukkitToX;
    }

    private void pullValues() {
        if (!this.pulled) {
            this.pulled = true;
            this.pullSystemValues();
        }
    }

    private static <T> void processEnumLikeFields(Class<T> clazz, BiConsumer<String, T> consumer) {
        for (Field field : clazz.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (field.getType() != clazz || !Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            try {
                consumer.accept(field.getName(), (String)field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void registerName(String name, XForm xForm) {
        this.nameMappings.put(XRegistry.normalizeName(name), xForm);
    }

    private void pullFieldNames() {
        XRegistry.processEnumLikeFields(this.xFormClass, this::registerName);
    }

    private void pullSystemValues() {
        if (this.isEnum) {
            for (BukkitForm bukkitForm : this.bukkitFormClass.getEnumConstants()) {
                this.std((XForm)bukkitForm);
            }
        } else {
            XRegistry.processEnumLikeFields(this.bukkitFormClass, (name, bukkit) -> {
                if (bukkit == null) {
                    return;
                }
                this.std((String)name, (BukkitForm)bukkit);
            });
        }
        if (this.supportsRegistry) {
            for (Keyed bukkitForm : this.bukkitRegistry()) {
                this.std((XForm)bukkitForm);
            }
        }
    }

    private BukkitForm valueOf(String name) {
        name = name.toUpperCase(Locale.ENGLISH).replace('.', '_');
        Class<BukkitForm> clazz = this.bukkitFormClass;
        return Enum.valueOf(clazz, name);
    }

    private Registry<?> bukkitRegistry() {
        return (Registry)this.registrySupplier.get();
    }

    @Nullable
    protected BukkitForm getBukkit(String[] names) {
        for (String name : names) {
            if (this.supportsRegistry) {
                NamespacedKey key = (name = name.toLowerCase(Locale.ENGLISH)).contains(":") ? NamespacedKey.fromString((String)name) : NamespacedKey.minecraft((String)name);
                Keyed bukkit = this.bukkitRegistry().get(key);
                return (BukkitForm)bukkit;
            }
            try {
                return this.valueOf(name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return null;
    }

    public @Unmodifiable Collection<XForm> getValues() {
        this.pullValues();
        return Collections.unmodifiableCollection(this.bukkitToX.values());
    }

    public XForm[] values() {
        Collection<XForm> values = this.getValues();
        return values.toArray((XModule[])this.createArray.apply(values.size()));
    }

    @Override
    @NotNull
    public Iterator<XForm> iterator() {
        return this.getValues().iterator();
    }

    public XForm getByBukkitForm(BukkitForm bukkit) {
        BukkitForm xForm;
        Objects.requireNonNull(bukkit, () -> "Cannot match null " + this.registryName);
        XModule mapping = (XModule)this.bukkitToX.get(bukkit);
        if (mapping == null && (xForm = this.std((XForm)bukkit)) == null) {
            throw new UnsupportedOperationException("Unknown " + this.registryName + ": " + bukkit);
        }
        return (XForm)mapping;
    }

    public Optional<XForm> getByName(@NotNull String name) {
        Objects.requireNonNull(name, () -> "Cannot match null " + this.registryName);
        if (name.isEmpty()) {
            return Optional.empty();
        }
        this.pullValues();
        return Optional.ofNullable((XModule)this.nameMappings.get(XRegistry.normalizeName(name)));
    }

    @ApiStatus.Internal
    public static String getName(Object bukkitForm) {
        Objects.requireNonNull(bukkitForm, "Cannot get name of a null bukkit form");
        if (bukkitForm instanceof Enum) {
            return ((Enum)bukkitForm).name();
        }
        if (bukkitForm instanceof Keyed) {
            return ((Keyed)bukkitForm).getKey().toString();
        }
        throw new AssertionError((Object)("Unknown xform type: " + bukkitForm + " (" + bukkitForm.getClass() + ')'));
    }

    @NotNull
    private static String format(@NotNull String name) {
        int len = name.length();
        char[] chs = new char[len];
        int count = 0;
        boolean appendUnderline = false;
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (!(appendUnderline || count == 0 || ch != '-' && ch != ' ' && ch != '_' || chs[count] == '_')) {
                appendUnderline = true;
                continue;
            }
            boolean number = false;
            if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') && !(number = ch >= '0' && ch <= '9')) continue;
            if (appendUnderline) {
                chs[count++] = 95;
                appendUnderline = false;
            }
            chs[count++] = number ? ch : (char)(ch & 0x5F);
        }
        return new String(chs, 0, count);
    }

    private static String normalizeName(String name) {
        if ((name = name.toLowerCase(Locale.ENGLISH)).startsWith("minecraft:")) {
            name = name.substring("minecraft:".length());
        }
        name = name.replace('.', '_');
        return name;
    }

    private XForm std(BukkitForm bukkit) {
        return this.std(null, bukkit);
    }

    private XForm std(@Nullable String extraFieldName, BukkitForm bukkit) {
        String[] stringArray;
        XModule xForm = (XModule)this.bukkitToX.get(bukkit);
        if (xForm != null) {
            return (XForm)xForm;
        }
        String name = XRegistry.getName(bukkit);
        if (this.getBukkit(new String[]{name}) == null && extraFieldName == null) {
            throw new IllegalArgumentException("Unknown standard bukkit form: " + bukkit + " named " + name);
        }
        if (extraFieldName == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = extraFieldName;
            stringArray = stringArray3;
            stringArray3[1] = name;
        }
        xForm = (XModule)this.creator.apply(bukkit, stringArray);
        this.registerName(name, xForm);
        if (extraFieldName != null) {
            this.registerName(extraFieldName, xForm);
        }
        this.bukkitToX.put(bukkit, xForm);
        return (XForm)xForm;
    }

    @ApiStatus.Internal
    public XForm std(String[] names) {
        BukkitForm bukkit = this.getBukkit(names);
        XModule xForm = (XModule)this.creator.apply(bukkit, names);
        return (XForm)this.std((XForm)xForm);
    }

    @ApiStatus.Internal
    public XForm std(Function<BukkitForm, XForm> xForm, String[] names) {
        BukkitForm bukkit = this.getBukkit(names);
        return (XForm)this.std((XForm)((XModule)xForm.apply(bukkit)));
    }

    @ApiStatus.Internal
    public XForm std(Function<BukkitForm, XForm> xForm, XForm tryOther, String[] names) {
        BukkitForm bukkit = this.getBukkit(names);
        if (bukkit == null) {
            bukkit = ((XModule)tryOther).get();
        }
        return (XForm)this.std((XForm)((XModule)xForm.apply(bukkit)));
    }

    @ApiStatus.Internal
    public XForm std(XForm xForm) {
        for (String name : ((XModule)xForm).getNames()) {
            this.registerName(name, xForm);
        }
        if (((XModule)xForm).isSupported()) {
            this.bukkitToX.put(((XModule)xForm).get(), xForm);
        }
        return xForm;
    }
}

