/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.xseries.base;

import com.conaxgames.libraries.xseries.base.XRegistry;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XModule<XForm extends XModule<XForm, BukkitForm>, BukkitForm> {
    private final BukkitForm bukkitForm;
    private final String[] names;

    protected XModule(BukkitForm bukkitForm, String[] names) {
        this.bukkitForm = bukkitForm;
        this.names = names;
    }

    @NotNull
    public final String name() {
        return this.names[0];
    }

    @ApiStatus.Experimental
    protected void setEnumName(XRegistry<XForm, BukkitForm> registry, String enumName) {
        if (this.names[0] != null) {
            throw new IllegalStateException("Enum name already set " + enumName + " -> " + Arrays.toString(this.names));
        }
        this.names[0] = enumName;
        BukkitForm newForm = registry.getBukkit(this.names);
        if (this.bukkitForm != newForm) {
            registry.std(this);
        }
    }

    @ApiStatus.Internal
    public String[] getNames() {
        return this.names;
    }

    public String friendlyName() {
        return Arrays.stream(this.name().split("_")).map(t -> t.charAt(0) + t.substring(1).toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(" "));
    }

    @Nullable
    public final BukkitForm get() {
        return this.bukkitForm;
    }

    public final boolean isSupported() {
        return this.get() != null;
    }

    @NotNull
    public final XForm or(XForm other) {
        return (XForm)(this.isSupported() ? this : other);
    }

    public final String toString() {
        return (this.isSupported() ? "" : "!") + this.getClass().getSimpleName() + '(' + this.name() + ')';
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @Deprecated
    public final boolean equals(Object obj) {
        return super.equals(obj);
    }
}

