/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util.cuboid;

import com.conaxgames.libraries.util.cuboid.RegionDirection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class Cuboid
implements Iterable<Location> {
    private String worldName;
    private int x1;
    private int y1;
    private int z1;
    private int x2;
    private int y2;
    private int z2;
    private String name;

    public Cuboid(Location l1, Location l2) {
        this(l1.getWorld().getName(), l1.getBlockX(), l1.getBlockY(), l1.getBlockZ(), l2.getBlockX(), l2.getBlockY(), l2.getBlockZ());
    }

    public Cuboid(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
        this(world.getName(), x1, y1, z1, x2, y2, z2);
    }

    public Cuboid(String worldName, int x1, int y1, int z1, int x2, int y2, int z2) {
        this.worldName = worldName;
        this.x1 = Math.min(x1, x2);
        this.x2 = Math.max(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.y2 = Math.max(y1, y2);
        this.z1 = Math.min(z1, z2);
        this.z2 = Math.max(z1, z2);
    }

    public Cuboid(Map<String, Object> map) {
        this.worldName = (String)map.get("worldName");
        this.x1 = (Integer)map.get("x1");
        this.x2 = (Integer)map.get("x2");
        this.y1 = (Integer)map.get("y1");
        this.y2 = (Integer)map.get("y2");
        this.z1 = (Integer)map.get("z1");
        this.z2 = (Integer)map.get("z2");
        this.name = (String)map.get("name");
    }

    public Location getLowerCorner() {
        return new Location(this.getWorld(), (double)this.x1, (double)this.y1, (double)this.z1);
    }

    public Location getUpperCorner() {
        return new Location(this.getWorld(), (double)this.x2, (double)this.y2, (double)this.z2);
    }

    public Location getCenter() {
        return new Location(this.getWorld(), (double)(this.x1 + (this.x2 - this.x1) / 2), (double)(this.y1 + (this.y2 - this.y1) / 2), (double)(this.z1 + (this.z2 - this.z1) / 2));
    }

    public World getWorld() {
        World world = Bukkit.getWorld((String)this.worldName);
        if (world == null) {
            throw new IllegalStateException("world '" + this.worldName + "' is not loaded");
        }
        return world;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("worldName", this.worldName);
        map.put("x1", this.x1);
        map.put("x2", this.x2);
        map.put("y1", this.y1);
        map.put("y2", this.y2);
        map.put("z1", this.z1);
        map.put("z2", this.z2);
        map.put("name", this.name);
        return map;
    }

    public int getSizeX() {
        return this.x2 - this.x1 + 1;
    }

    public int getSizeY() {
        return this.y2 - this.y1 + 1;
    }

    public int getSizeZ() {
        return this.z2 - this.z1 + 1;
    }

    public Location[] getCorners() {
        Location[] res = new Location[4];
        World w = this.getWorld();
        res[0] = new Location(w, (double)this.x1, 0.0, (double)this.z1);
        res[1] = new Location(w, (double)this.x2, 0.0, (double)this.z1);
        res[2] = new Location(w, (double)this.x2, 0.0, (double)this.z2);
        res[3] = new Location(w, (double)this.x1, 0.0, (double)this.z2);
        return res;
    }

    public Cuboid expand(RegionDirection dir, int amount) {
        switch (dir) {
            case NORTH: {
                return new Cuboid(this.worldName, this.x1 - amount, this.y1, this.z1, this.x2, this.y2, this.z2);
            }
            case SOUTH: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2 + amount, this.y2, this.z2);
            }
            case EASY: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1 - amount, this.x2, this.y2, this.z2);
            }
            case WEST: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y2, this.z2 + amount);
            }
            case DOWN: {
                return new Cuboid(this.worldName, this.x1, this.y1 - amount, this.z1, this.x2, this.y2, this.z2);
            }
            case UP: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y2 + amount, this.z2);
            }
        }
        throw new IllegalArgumentException("invalid direction " + (Object)((Object)dir));
    }

    public Cuboid shift(RegionDirection dir, int amount) {
        return this.expand(dir, amount).expand(dir.opposite(), -amount);
    }

    public Cuboid outset(RegionDirection dir, int amount) {
        Cuboid c;
        switch (dir) {
            case HORIZONTAL: {
                c = this.expand(RegionDirection.NORTH, amount).expand(RegionDirection.SOUTH, amount).expand(RegionDirection.EASY, amount).expand(RegionDirection.WEST, amount);
                break;
            }
            case VERTICAL: {
                c = this.expand(RegionDirection.DOWN, amount).expand(RegionDirection.UP, amount);
                break;
            }
            case BOTH: {
                c = this.outset(RegionDirection.HORIZONTAL, amount).outset(RegionDirection.VERTICAL, amount);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid direction " + (Object)((Object)dir));
            }
        }
        return c;
    }

    public Cuboid inset(RegionDirection dir, int amount) {
        return this.outset(dir, -amount);
    }

    public boolean contains(int x, int y, int z) {
        return x >= this.x1 && x <= this.x2 && y >= this.y1 && y <= this.y2 && z >= this.z1 && z <= this.z2;
    }

    public boolean contains(int x, int z) {
        return x >= this.x1 && x <= this.x2 && z >= this.z1 && z <= this.z2;
    }

    public boolean contains(Location l) {
        if (!this.worldName.equals(l.getWorld().getName())) {
            return false;
        }
        return this.contains(l.getBlockX(), l.getBlockY(), l.getBlockZ());
    }

    public boolean contains(Block b) {
        return this.contains(b.getLocation());
    }

    public int volume() {
        return this.getSizeX() * this.getSizeY() * this.getSizeZ();
    }

    public Cuboid getFace(RegionDirection dir) {
        switch (dir) {
            case DOWN: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y1, this.z2);
            }
            case UP: {
                return new Cuboid(this.worldName, this.x1, this.y2, this.z1, this.x2, this.y2, this.z2);
            }
            case NORTH: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x1, this.y2, this.z2);
            }
            case SOUTH: {
                return new Cuboid(this.worldName, this.x2, this.y1, this.z1, this.x2, this.y2, this.z2);
            }
            case EASY: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z1, this.x2, this.y2, this.z1);
            }
            case WEST: {
                return new Cuboid(this.worldName, this.x1, this.y1, this.z2, this.x2, this.y2, this.z2);
            }
        }
        throw new IllegalArgumentException("Invalid direction " + (Object)((Object)dir));
    }

    public Cuboid getBoundingRegion(Cuboid other) {
        if (other == null) {
            return this;
        }
        int xMin = Math.min(this.x1, other.x1);
        int yMin = Math.min(this.y1, other.y1);
        int zMin = Math.min(this.z1, other.z1);
        int xMax = Math.max(this.x2, other.x2);
        int yMax = Math.max(this.y2, other.y2);
        int zMax = Math.max(this.z2, other.z2);
        return new Cuboid(this.worldName, xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public Block getRelativeBlock(int x, int y, int z) {
        return this.getWorld().getBlockAt(this.x1 + x, this.y1 + y, this.z1 + z);
    }

    public Block getRelativeBlock(World w, int x, int y, int z) {
        return w.getBlockAt(this.x1 + x, this.y1 + y, this.z1 + z);
    }

    public List<Chunk> getChunks() {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        World w = this.getWorld();
        int x1 = this.x1 & 0xFFFFFFF0;
        int x2 = this.x2 & 0xFFFFFFF0;
        int z1 = this.z1 & 0xFFFFFFF0;
        int z2 = this.z2 & 0xFFFFFFF0;
        for (int x = x1; x <= x2; x += 16) {
            for (int z = z1; z <= z2; z += 16) {
                chunks.add(w.getChunkAt(x >> 4, z >> 4));
            }
        }
        return chunks;
    }

    public Cuboid[] getWalls() {
        return new Cuboid[]{this.getFace(RegionDirection.NORTH), this.getFace(RegionDirection.SOUTH), this.getFace(RegionDirection.WEST), this.getFace(RegionDirection.EASY)};
    }

    @Override
    public Iterator<Location> iterator() {
        return new LocationRegionIterator(this.getWorld(), this.x1, this.y1, this.z1, this.x2, this.y2, this.z2);
    }

    public String toString() {
        return "Cuboid: " + this.worldName + "," + this.x1 + "," + this.y1 + "," + this.z1 + "=>" + this.x2 + "," + this.y2 + "," + this.z2;
    }

    public Location getRandomLocation() {
        return this.getRandomLocation(this.getLowerCorner(), this.getUpperCorner());
    }

    public Location getRandomLocation(Location min, Location max) {
        Location range = new Location(min.getWorld(), Math.abs(max.getX() - min.getX()), min.getY(), Math.abs(max.getZ() - min.getZ()));
        return new Location(min.getWorld(), Math.random() * range.getX() + Math.min(min.getX(), max.getX()), range.getY(), Math.random() * range.getZ() + Math.min(min.getZ(), max.getZ()));
    }

    @Generated
    public String getWorldName() {
        return this.worldName;
    }

    @Generated
    public int getX1() {
        return this.x1;
    }

    @Generated
    public int getY1() {
        return this.y1;
    }

    @Generated
    public int getZ1() {
        return this.z1;
    }

    @Generated
    public int getX2() {
        return this.x2;
    }

    @Generated
    public int getY2() {
        return this.y2;
    }

    @Generated
    public int getZ2() {
        return this.z2;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    @Generated
    public void setX1(int x1) {
        this.x1 = x1;
    }

    @Generated
    public void setY1(int y1) {
        this.y1 = y1;
    }

    @Generated
    public void setZ1(int z1) {
        this.z1 = z1;
    }

    @Generated
    public void setX2(int x2) {
        this.x2 = x2;
    }

    @Generated
    public void setY2(int y2) {
        this.y2 = y2;
    }

    @Generated
    public void setZ2(int z2) {
        this.z2 = z2;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cuboid)) {
            return false;
        }
        Cuboid other = (Cuboid)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX1() != other.getX1()) {
            return false;
        }
        if (this.getY1() != other.getY1()) {
            return false;
        }
        if (this.getZ1() != other.getZ1()) {
            return false;
        }
        if (this.getX2() != other.getX2()) {
            return false;
        }
        if (this.getY2() != other.getY2()) {
            return false;
        }
        if (this.getZ2() != other.getZ2()) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Cuboid;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX1();
        result = result * 59 + this.getY1();
        result = result * 59 + this.getZ1();
        result = result * 59 + this.getX2();
        result = result * 59 + this.getY2();
        result = result * 59 + this.getZ2();
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public class LocationRegionIterator
    implements Iterator<Location> {
        private final World w;
        private final int baseX;
        private final int baseY;
        private final int baseZ;
        private int x;
        private int y;
        private int z;
        private final int sizeX;
        private final int sizeY;
        private final int sizeZ;

        public LocationRegionIterator(World w, int x1, int y1, int z1, int x2, int y2, int z2) {
            this.w = w;
            this.baseX = x1;
            this.baseY = y1;
            this.baseZ = z1;
            this.sizeX = Math.abs(x2 - x1) + 1;
            this.sizeY = Math.abs(y2 - y1) + 1;
            this.sizeZ = Math.abs(z2 - z1) + 1;
            this.z = 0;
            this.y = 0;
            this.x = 0;
        }

        @Override
        public boolean hasNext() {
            return this.x < this.sizeX && this.y < this.sizeY && this.z < this.sizeZ;
        }

        @Override
        public Location next() {
            Location b = new Location(this.w, (double)(this.baseX + this.x), (double)(this.baseY + this.y), (double)(this.baseZ + this.z));
            if (++this.x >= this.sizeX) {
                this.x = 0;
                if (++this.y >= this.sizeY) {
                    this.y = 0;
                    ++this.z;
                }
            }
            return b;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

