/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util.center;

import com.conaxgames.libraries.util.CC;
import com.conaxgames.libraries.util.center.DefaultFontInfo;
import org.bukkit.entity.Player;

public class Center {
    private static final int CENTER_PX = 154;

    public static String getCentered(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        message = CC.translate(message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = c == 'l' || c == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 154 - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return sb.toString() + message;
    }

    public static void sendCenteredMessage(Player player, String message) {
        player.sendMessage(Center.getCentered(message));
    }
}

