/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util;

import com.google.common.base.Preconditions;
import org.bukkit.entity.Player;

public class XPUtil {
    private final Player player;
    private final String playerName;

    public XPUtil(Player player) {
        Preconditions.checkNotNull((Object)player, (Object)"Player cannot be null");
        this.player = player;
        this.playerName = player.getName();
    }

    public Player getPlayer() {
        Player p = this.player;
        if (p == null) {
            throw new IllegalStateException("Player " + this.playerName + " is not online");
        }
        return p;
    }

    private static int calculateLevelForExp(int exp) {
        int level = 0;
        int curExp = 7;
        int incr = 10;
        while (curExp <= exp) {
            curExp += incr;
            incr += ++level % 2 == 0 ? 3 : 4;
        }
        return level;
    }

    public void setExp(int amt) {
        this.setExp(0.0, amt);
    }

    public void setExp(double amt) {
        this.setExp(0.0, amt);
    }

    private void setExp(double base, double amt) {
        this.player.setExp(0.0f);
        this.player.setLevel(0);
        this.player.setTotalExperience(0);
        int amount = (int)amt;
        while (amount > 0) {
            int expToLevel = XPUtil.getExpAtLevel(this.player);
            if ((amount -= expToLevel) >= 0) {
                this.player.giveExp(expToLevel);
                continue;
            }
            this.player.giveExp(amount += expToLevel);
            amount = 0;
        }
    }

    public int getCurrentExp() {
        int exp = Math.round((float)XPUtil.getExpAtLevel(this.player) * this.player.getExp());
        int currentLevel = this.player.getLevel();
        while (currentLevel > 0) {
            exp += XPUtil.getExpAtLevel(--currentLevel);
        }
        if (exp < 0) {
            exp = Integer.MAX_VALUE;
        }
        return exp;
    }

    public boolean hasExp(int amt) {
        return this.getCurrentExp() >= amt;
    }

    public int getXpNeededToLevelUp(int level) {
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (Object)"Level may not be negative.");
        int exp = 0;
        for (int currentLevel = 0; currentLevel < level; ++currentLevel) {
            exp += XPUtil.getExpAtLevel(currentLevel);
        }
        if (exp < 0) {
            exp = Integer.MAX_VALUE;
        }
        return exp;
    }

    private static int getExpAtLevel(Player player) {
        return XPUtil.getExpAtLevel(player.getLevel());
    }

    public static int getExpAtLevel(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level >= 16 && level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }
}

