/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util;

import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Tristate {
    NOT_SET,
    FALSE,
    TRUE;


    @Nullable
    public Boolean toBoolean() {
        switch (this.ordinal()) {
            case 2: {
                return Boolean.TRUE;
            }
            case 1: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public boolean toBooleanOrDefault(boolean def) {
        switch (this.ordinal()) {
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return def;
    }

    public boolean toBooleanOrElseGet(@NotNull BooleanSupplier supplier) {
        switch (this.ordinal()) {
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return supplier.getAsBoolean();
    }

    @NotNull
    public static Tristate fromBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    @NotNull
    public static Tristate fromBoolean(@Nullable Boolean value) {
        return value == null ? NOT_SET : Tristate.fromBoolean(value);
    }
}

