/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StringUtils {
    public static Pattern UUID_REGEX = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");

    public static String color(String msg) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
    }

    public static void log(Level lvl, String msg) {
        Bukkit.getLogger().log(lvl, msg);
    }

    public static void sendMessage(Player p, String msg) {
        p.sendMessage(StringUtils.color(msg));
    }

    public static void sendMessage(UUID uuid, String msg) {
        if (Bukkit.getPlayer((UUID)uuid) != null) {
            StringUtils.sendMessage(Bukkit.getPlayer((UUID)uuid), msg);
        }
    }

    public static void sendMessage(CommandSender sender, String msg) {
        sender.sendMessage(StringUtils.color(msg));
    }

    public static String join(Collection coll, String string) {
        StringBuilder builder = new StringBuilder();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            if (builder.length() != 0) {
                builder.append(string);
            }
            builder.append((String)it.next());
        }
        return builder.toString();
    }

    public static String getHealth(Player p) {
        int roundedHearts = (int)Math.floor(p.getHealth() / 2.0) == 0 ? 1 : (int)Math.floor(p.getHealth() / 2.0);
        return StringUtils.color("&c" + roundedHearts + " &4\u2764");
    }
}

