/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util;

import com.conaxgames.libraries.LibraryPlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class License {
    private String licenseKey;
    private Plugin plugin;
    private String validationServer;
    private LogType logType = LogType.NORMAL;
    private String securityKey = "YecoF0I6M05thxLeokoHuW8iUhTdIUInjkfF";
    private boolean debug = false;

    public License(String licenseKey, String validationServer, Plugin plugin) {
        this.licenseKey = licenseKey;
        this.plugin = plugin;
        this.validationServer = validationServer;
    }

    public License setSecurityKey(String securityKey) {
        this.securityKey = securityKey;
        return this;
    }

    public License setConsoleLog(LogType logType) {
        this.logType = logType;
        return this;
    }

    public License debug() {
        this.debug = true;
        return this;
    }

    public boolean register() {
        ValidationType vt = this.isValid();
        if (vt == ValidationType.VALID) {
            LibraryPlugin.getInstance().getLibraryLogger().toConsole("License Checker", "License key seems to be valid :>", new Throwable[0]);
            return true;
        }
        try {
            URLConnection connection = new URL("https://cdn.conaxgames.com/license/verify.php").openConnection();
            connection.connect();
            LibraryPlugin.getInstance().getLibraryLogger().toConsole("License Checker", "Web server is online! but license is invalid", new Throwable[0]);
            Bukkit.getScheduler().cancelTasks(this.plugin);
            Bukkit.getPluginManager().disablePlugin(this.plugin);
            return false;
        }
        catch (IOException e) {
            LibraryPlugin.getInstance().getLibraryLogger().toConsole("License Checker", "Web server seems to be unreachable, Ignoring license key", new Throwable[0]);
            return true;
        }
    }

    public boolean isValidSimple() {
        return this.isValid() == ValidationType.VALID;
    }

    private String requestServer(String v1, String v2) throws IOException {
        URL url = new URL(this.validationServer + "?v1=" + v1 + "&v2=" + v2 + "&pl=" + this.plugin.getName());
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("User-Agent", "Mozilla/5.0");
        int responseCode = con.getResponseCode();
        if (this.debug) {
            System.out.println("\nSending 'GET' request to URL : " + url);
            System.out.println("Response Code : " + responseCode);
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            String inputLine;
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            String string = response.toString();
            return string;
        }
    }

    public ValidationType isValid() {
        String rand = this.toBinary(UUID.randomUUID().toString());
        String sKey = this.toBinary(this.securityKey);
        String key = this.toBinary(this.licenseKey);
        try {
            String response = this.requestServer(License.xor(rand, sKey), License.xor(rand, key));
            if (response.startsWith("<")) {
                this.log(1, "The license server returned an invalid response.");
                this.log(1, "1) Your web host injects JS into the page.");
                this.log(1, "2) Your validationserver-URL is incorrect.");
                this.log(1, "SERVER-RESPONSE: " + (response.length() < 150 || this.debug ? response : response.substring(0, 150) + "..."));
                return ValidationType.PAGE_ERROR;
            }
            try {
                return ValidationType.valueOf(response);
            }
            catch (IllegalArgumentException exc) {
                String respRand = License.xor(License.xor(response, key), sKey);
                if (rand.substring(0, respRand.length()).equals(respRand)) {
                    return ValidationType.VALID;
                }
                return ValidationType.WRONG_RESPONSE;
            }
        }
        catch (IOException e) {
            if (this.debug) {
                e.printStackTrace();
            }
            return ValidationType.PAGE_ERROR;
        }
    }

    private static String xor(String s1, String s2) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < Math.min(s1.length(), s2.length()); ++i) {
            result.append(Byte.parseByte("" + s1.charAt(i)) ^ Byte.parseByte(s2.charAt(i) + ""));
        }
        return result.toString();
    }

    private String toBinary(String s) {
        byte[] bytes = s.getBytes();
        StringBuilder binary = new StringBuilder();
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int b;
            int val = b = byArray[i];
            for (int i2 = 0; i2 < 8; ++i2) {
                binary.append((val & 0x80) == 0 ? 0 : 1);
                val <<= 1;
            }
        }
        return binary.toString();
    }

    private void log(int type, String message) {
        if (this.logType == LogType.NONE || this.logType == LogType.LOW && type == 0) {
            return;
        }
        System.out.println(message);
    }

    public static enum LogType {
        NORMAL,
        LOW,
        NONE;

    }

    public static enum ValidationType {
        WRONG_RESPONSE,
        PAGE_ERROR,
        URL_ERROR,
        KEY_OUTDATED,
        KEY_NOT_FOUND,
        NOT_VALID_IP,
        INVALID_PLUGIN,
        VALID;

    }
}

