/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class JavaUtils {
    private static final CharMatcher CHAR_MATCHER_ASCII = CharMatcher.inRange((char)'0', (char)'9').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.whitespace()).precomputed();
    private static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[34][0-9a-fA-F]{3}-[89ab][0-9a-fA-F]{3}-[0-9a-fA-F]{12}");
    private static final int DEFAULT_NUMBER_FORMAT_DECIMAL_PLACES = 5;

    private JavaUtils() {
    }

    public static Integer tryParseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static Double tryParseDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static boolean isUUID(String string) {
        return UUID_PATTERN.matcher(string).find();
    }

    public static boolean isAlphanumeric(String string) {
        return CHAR_MATCHER_ASCII.matchesAllOf((CharSequence)string);
    }

    public static boolean containsIgnoreCase(Iterable<? extends String> elements, String string) {
        for (String string2 : elements) {
            if (!StringUtils.containsIgnoreCase((CharSequence)string2, (CharSequence)string)) continue;
            return true;
        }
        return false;
    }

    public static String format(Number number) {
        return JavaUtils.format(number, 5);
    }

    public static String format(Number number, int decimalPlaces) {
        return JavaUtils.format(number, decimalPlaces, RoundingMode.HALF_DOWN);
    }

    public static String format(Number number, int decimalPlaces, RoundingMode roundingMode) {
        Preconditions.checkNotNull((Object)number, (Object)"The number cannot be null");
        return new BigDecimal(number.toString()).setScale(decimalPlaces, roundingMode).stripTrailingZeros().toPlainString();
    }

    public static String andJoin(Collection<String> collection, boolean delimiterBeforeAnd) {
        return JavaUtils.andJoin(collection, delimiterBeforeAnd, ", ");
    }

    public static String andJoin(Collection<String> collection, boolean delimiterBeforeAnd, String delimiter) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        ArrayList<String> contents = new ArrayList<String>(collection);
        String last = (String)contents.remove(contents.size() - 1);
        StringBuilder builder = new StringBuilder(Joiner.on((String)delimiter).join(contents));
        if (delimiterBeforeAnd) {
            builder.append(delimiter);
        }
        return builder.append(" and ").append(last).toString();
    }

    public static long parse(String input) {
        if (input == null || input.isEmpty()) {
            return -1L;
        }
        long result = 0L;
        StringBuilder number = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            String str;
            char c = input.charAt(i);
            if (Character.isDigit(c)) {
                number.append(c);
                continue;
            }
            if (!Character.isLetter(c) || (str = number.toString()).isEmpty()) continue;
            result += JavaUtils.convert(Integer.parseInt(str), c);
            number = new StringBuilder();
        }
        return result;
    }

    private static long convert(int value, char unit) {
        switch (unit) {
            case 'y': {
                return (long)value * TimeUnit.DAYS.toMillis(365L);
            }
            case 'M': {
                return (long)value * TimeUnit.DAYS.toMillis(30L);
            }
            case 'd': {
                return (long)value * TimeUnit.DAYS.toMillis(1L);
            }
            case 'h': {
                return (long)value * TimeUnit.HOURS.toMillis(1L);
            }
            case 'm': {
                return (long)value * TimeUnit.MINUTES.toMillis(1L);
            }
            case 's': {
                return (long)value * TimeUnit.SECONDS.toMillis(1L);
            }
        }
        return -1L;
    }
}

