/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util;

public class JaroWinklerScore {
    public static double compute(String s1, String s2) {
        if (s1 == null || s2 == null || s1.isEmpty() || s2.isEmpty()) {
            return 0.0;
        }
        if (s1.equals(s2)) {
            return 1.0;
        }
        int prefixMatch = 0;
        int matches = 0;
        int transpositions = 0;
        int maxLength = Math.max(s1.length(), s2.length());
        int maxMatchDistance = Math.max((int)Math.floor((double)maxLength / 2.0) - 1, 0);
        String shorter = s1.length() < s2.length() ? s1 : s2;
        String longer = s1.length() >= s2.length() ? s1 : s2;
        block0: for (int i = 0; i < shorter.length(); ++i) {
            boolean match;
            boolean bl = match = shorter.charAt(i) == longer.charAt(i);
            if (match) {
                if (i < 4) {
                    ++prefixMatch;
                }
                ++matches;
                continue;
            }
            for (int j = Math.max(i - maxMatchDistance, 0); j < Math.min(i + maxMatchDistance, longer.length()); ++j) {
                if (i == j) continue;
                boolean bl2 = match = shorter.charAt(i) == longer.charAt(j);
                if (!match) continue;
                ++transpositions;
                continue block0;
            }
        }
        if (matches == 0) {
            return 0.0;
        }
        transpositions = (int)((double)transpositions / 2.0);
        double score = 0.3334 * ((double)matches / (double)longer.length() + (double)matches / (double)shorter.length() + (double)(matches - transpositions) / (double)matches);
        if (score < 0.7) {
            return score;
        }
        return score + (double)prefixMatch * 0.1 * (1.0 - score);
    }
}

