/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util;

import com.conaxgames.libraries.message.FormatUtil;
import com.conaxgames.libraries.message.ItemNameUtil;
import com.conaxgames.libraries.message.TimeUtil;
import com.conaxgames.libraries.util.CC;
import com.conaxgames.libraries.util.ItemFlagHelper;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public final class ItemUtil {
    private ItemUtil() {
        throw new RuntimeException("Cannot instantiate a utility class.");
    }

    public static String formatMaterial(Material material) {
        String name = material.toString();
        name = name.replace('_', ' ');
        String result = "" + name.charAt(0);
        for (int i = 1; i < name.length(); ++i) {
            result = name.charAt(i - 1) == ' ' ? result + name.charAt(i) : result + Character.toLowerCase(name.charAt(i));
        }
        return result;
    }

    public static ItemStack createPotion(String name, PotionType type, int level, int duration) {
        ItemStack itemStack = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)itemStack.getItemMeta();
        if (name != null) {
            meta.setDisplayName(CC.translate(name));
        }
        meta.setLore(Arrays.asList("", CC.GRAY + ItemNameUtil.potionLookup(type.getEffectType()) + " " + FormatUtil.toRoman(level) + " Potion", CC.GRAY + "    Duration: " + TimeUtil.millisToRoundedTime((long)duration * 1000L)));
        meta.addCustomEffect(new PotionEffect(type.getEffectType(), duration * 20, level - 1), false);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlagHelper.getHideTooltipFlag()});
        itemStack.setItemMeta((ItemMeta)meta);
        return itemStack;
    }

    public static ItemStack createPotion(PotionType type, int level, int duration) {
        return ItemUtil.createPotion(null, type, level, duration);
    }

    public static ItemStack enchantItem(ItemStack itemStack, ItemEnchant ... enchantments) {
        Arrays.asList(enchantments).forEach(enchantment -> itemStack.addUnsafeEnchantment(((ItemEnchant)enchantment).enchantment, ((ItemEnchant)enchantment).level));
        return itemStack;
    }

    public static ItemStack createItem(Material material, String name) {
        return ItemUtil.createItem(material, name, true);
    }

    public static ItemStack createItem(Material material, String name, boolean colors) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(colors ? CC.translate(name) : name);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createItem(Material material, String name, int amount) {
        ItemStack item = new ItemStack(material, amount);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(CC.translate(name));
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createItem(Material material, String name, int amount, short damage) {
        ItemStack item = new ItemStack(material, amount, damage);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(CC.translate(name));
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack hideEnchants(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_UNBREAKABLE});
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack renameItem(ItemStack item, String name) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(CC.translate(name));
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack reloreItem(ItemStack item, String ... lores) {
        return ItemUtil.reloreItem(ReloreType.OVERWRITE, item, lores);
    }

    public static ItemStack reloreItem(ReloreType type, ItemStack item, String ... lores) {
        ItemMeta meta = item.getItemMeta();
        LinkedList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new LinkedList<String>();
        }
        switch (type.ordinal()) {
            case 2: {
                lore.addAll(Arrays.asList(lores));
                meta.setLore(ItemUtil.translate(lore));
                break;
            }
            case 1: {
                LinkedList<String> nLore = new LinkedList<String>(Arrays.asList(lores));
                nLore.addAll(ItemUtil.translate(lore));
                meta.setLore(ItemUtil.translate(nLore));
                break;
            }
            case 0: {
                meta.setLore(Arrays.asList(lores));
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack addItemFlag(ItemStack item, ItemFlag flag) {
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{flag});
        item.setItemMeta(meta);
        return item;
    }

    public static DyeColor getDyeColorByChar(String colorString) {
        switch (ChatColor.getByChar((char)colorString.charAt(colorString.indexOf(167) + 1))) {
            case DARK_BLUE: 
            case BLUE: {
                return DyeColor.BLUE;
            }
            case DARK_GREEN: {
                return DyeColor.GREEN;
            }
            case GREEN: {
                return DyeColor.LIME;
            }
            case DARK_AQUA: 
            case AQUA: {
                return DyeColor.CYAN;
            }
            case DARK_RED: 
            case RED: {
                return DyeColor.RED;
            }
            case DARK_PURPLE: {
                return DyeColor.PURPLE;
            }
            case LIGHT_PURPLE: {
                return DyeColor.PINK;
            }
            case GOLD: {
                return DyeColor.ORANGE;
            }
            case GRAY: 
            case DARK_GRAY: {
                return DyeColor.GRAY;
            }
            case YELLOW: {
                return DyeColor.YELLOW;
            }
            case WHITE: {
                return DyeColor.WHITE;
            }
        }
        return DyeColor.BLACK;
    }

    public static int getWoolDmgValue(String colorString) {
        if (ChatColor.getByChar((char)(colorString = colorString.replace("&", "\u00a7")).charAt(colorString.indexOf(167) + 1)) == null) {
            return 15;
        }
        switch (ChatColor.getByChar((char)colorString.charAt(colorString.indexOf(167) + 1))) {
            case DARK_BLUE: 
            case BLUE: {
                return 11;
            }
            case DARK_GREEN: {
                return 13;
            }
            case GREEN: {
                return 5;
            }
            case DARK_AQUA: {
                return 9;
            }
            case AQUA: {
                return 3;
            }
            case DARK_RED: 
            case RED: {
                return 14;
            }
            case DARK_PURPLE: {
                return 10;
            }
            case LIGHT_PURPLE: {
                return 2;
            }
            case GOLD: {
                return 1;
            }
            case GRAY: {
                return 8;
            }
            case DARK_GRAY: {
                return 7;
            }
            case YELLOW: {
                return 4;
            }
            case BLACK: {
                return 15;
            }
        }
        return 0;
    }

    private static List<String> translate(List<String> text) {
        return text.stream().map(CC::translate).collect(Collectors.toList());
    }

    public static enum ReloreType {
        OVERWRITE,
        PREPEND,
        APPEND;

    }

    public static class ItemEnchant {
        private final Enchantment enchantment;
        private final int level;

        public ItemEnchant(Enchantment enchantment, int level) {
            this.enchantment = enchantment;
            this.level = level;
        }
    }
}

