/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util;

import com.conaxgames.libraries.util.VersioningChecker;
import com.conaxgames.libraries.xseries.XMaterial;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilderUtil {
    private ItemStack is;

    public ItemBuilderUtil(Material m) {
        this(m, 1);
    }

    public ItemBuilderUtil(ItemStack is) {
        this.is = is;
    }

    public ItemBuilderUtil(Material m, int amount) {
        this.is = new ItemStack(m, amount);
    }

    public ItemBuilderUtil(Material m, int amount, byte durability) {
        this.is = new ItemStack(m, amount, (short)durability);
    }

    public ItemBuilderUtil clone() {
        return new ItemBuilderUtil(this.is);
    }

    public ItemBuilderUtil setDurability(short dur) {
        this.is.setDurability(dur);
        return this;
    }

    public ItemBuilderUtil setName(String name) {
        ItemMeta im = this.is.getItemMeta();
        im.setDisplayName(name);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilderUtil addUnsafeEnchantment(Enchantment ench, int level) {
        this.is.addUnsafeEnchantment(ench, level);
        return this;
    }

    public ItemBuilderUtil addUnsafeEnchantmentIf(Boolean bool, Enchantment ench, int level) {
        if (bool.booleanValue()) {
            this.is.addUnsafeEnchantment(ench, level);
        }
        return this;
    }

    public ItemBuilderUtil removeEnchantment(Enchantment ench) {
        this.is.removeEnchantment(ench);
        return this;
    }

    public ItemBuilderUtil setSkullOwner(String name) {
        SkullMeta meta = (SkullMeta)this.is.getItemMeta();
        meta.setOwner(name);
        this.is.setItemMeta((ItemMeta)meta);
        return this;
    }

    public ItemBuilderUtil setSkullProfile(String texture) {
        SkullMeta meta = (SkullMeta)this.is.getItemMeta();
        GameProfile profile = new GameProfile(UUID.randomUUID(), "");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
        try {
            Field profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(meta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        this.is.setItemMeta((ItemMeta)meta);
        return this;
    }

    public ItemBuilderUtil addEnchant(Enchantment ench, int level) {
        ItemMeta im = this.is.getItemMeta();
        im.addEnchant(ench, level, true);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilderUtil addEnchantments(Map<Enchantment, Integer> enchantments) {
        this.is.addEnchantments(enchantments);
        return this;
    }

    public ItemBuilderUtil setInfinityDurability() {
        this.is.setDurability((short)Short.MAX_VALUE);
        return this;
    }

    public ItemBuilderUtil setLore(String ... lore) {
        ItemMeta im = this.is.getItemMeta();
        im.setLore(Arrays.asList(lore));
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilderUtil setLore(List<String> lore) {
        ItemMeta im = this.is.getItemMeta();
        im.setLore(lore);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilderUtil removeLoreLine(String line) {
        ItemMeta im = this.is.getItemMeta();
        ArrayList lore = new ArrayList(im.getLore());
        if (!lore.contains(line)) {
            return this;
        }
        lore.remove(line);
        im.setLore(lore);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilderUtil removeLoreLine(int index) {
        ItemMeta im = this.is.getItemMeta();
        ArrayList lore = new ArrayList(im.getLore());
        if (index < 0 || index > lore.size()) {
            return this;
        }
        lore.remove(index);
        im.setLore(lore);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilderUtil addLoreLine(String line) {
        ItemMeta im = this.is.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        if (im.hasLore()) {
            lore = new ArrayList(im.getLore());
        }
        lore.add(line);
        im.setLore(lore);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilderUtil addLoreLineIf(Boolean bool, String line) {
        if (bool.booleanValue()) {
            ItemMeta im = this.is.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            if (im.hasLore()) {
                lore = new ArrayList(im.getLore());
            }
            lore.add(line);
            im.setLore(lore);
            this.is.setItemMeta(im);
            return this;
        }
        return this;
    }

    public ItemBuilderUtil addLoreLineList(List<String> line) {
        ItemMeta im = this.is.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        if (im.hasLore()) {
            lore = new ArrayList(im.getLore());
        }
        lore.addAll(line);
        im.setLore(lore);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilderUtil addLoreLine(String line, int pos) {
        ItemMeta im = this.is.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>(im.getLore());
        lore.set(pos, line);
        im.setLore(lore);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilderUtil setDyeColor(DyeColor color) {
        this.is.setDurability(VersioningChecker.getInstance().isServerVersionBefore("1.16.5") ? (short)color.getWoolData() : (short)color.getDyeData());
        return this;
    }

    @Deprecated
    public ItemBuilderUtil setWoolColor(DyeColor color) {
        if (!this.is.getType().equals((Object)XMaterial.WHITE_WOOL.parseMaterial())) {
            return this;
        }
        this.is.setDurability(VersioningChecker.getInstance().isServerVersionBefore("1.16.5") ? (short)color.getWoolData() : (short)color.getDyeData());
        return this;
    }

    public ItemBuilderUtil setLeatherArmorColor(Color color) {
        try {
            LeatherArmorMeta im = (LeatherArmorMeta)this.is.getItemMeta();
            im.setColor(color);
            this.is.setItemMeta((ItemMeta)im);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilderUtil setUnbreakable() {
        ItemMeta meta = this.is.getItemMeta();
        if (meta != null) {
            ItemBuilderUtil.setUnbreakable(meta, true);
        }
        this.is.setItemMeta(meta);
        return this;
    }

    public static ItemMeta setUnbreakable(ItemMeta meta, boolean value) {
        meta.setUnbreakable(value);
        return meta;
    }

    public ItemBuilderUtil setFlags(ItemFlag ... flags) {
        ItemMeta meta = this.is.getItemMeta();
        if (meta != null) {
            meta.addItemFlags(flags);
        }
        this.is.setItemMeta(meta);
        return this;
    }

    public ItemBuilderUtil removeFlags(ItemFlag ... flags) {
        ItemMeta meta = this.is.getItemMeta();
        if (meta != null) {
            meta.removeItemFlags(flags);
        }
        this.is.setItemMeta(meta);
        return this;
    }

    public ItemBuilderUtil setAmount(int amount) {
        this.is.setAmount(amount);
        return this;
    }

    public ItemBuilderUtil setCustomModelData(int modelData) {
        ItemMeta meta = this.is.getItemMeta();
        if (meta != null) {
            meta.setCustomModelData(Integer.valueOf(modelData));
        }
        this.is.setItemMeta(meta);
        return this;
    }

    public ItemBuilderUtil setSkin(String texture) {
        SkullMeta meta;
        if (this.is.getType() == Material.PLAYER_HEAD && (meta = (SkullMeta)this.is.getItemMeta()) != null) {
            GameProfile profile = new GameProfile(UUID.randomUUID(), null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
            try {
                Field profileField = meta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
                profileField.set(meta, profile);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
            this.is.setItemMeta((ItemMeta)meta);
        }
        return this;
    }

    public ItemStack toItemStack() {
        return this.is;
    }

    public ItemStack build() {
        return this.is;
    }
}

