/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import javax.management.MBeanServer;

public class HeapUtil {
    private static volatile Object hotspotMBean;

    public static void dumpHeap(String fileName, boolean live) {
        HeapUtil.initHotspotMBean();
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Method m = clazz.getMethod("dumpHeap", String.class, Boolean.TYPE);
            m.invoke(hotspotMBean, fileName, live);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() {
        if (hotspotMBean != null) return;
        Class<HeapUtil> clazz = HeapUtil.class;
        synchronized (HeapUtil.class) {
            if (hotspotMBean != null) return;
            hotspotMBean = HeapUtil.getHotspotMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static Object getHotspotMBean() {
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Object bean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", clazz);
            return bean;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }
}

