/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util;

import java.text.NumberFormat;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class Formatter {
    private static final NavigableMap<Double, String> suffixes = new TreeMap<Double, String>();

    public static String commaFormatInteger(Integer integer) {
        return NumberFormat.getIntegerInstance().format(integer);
    }

    public static String oneDecimalFormat(Double number) {
        return String.format("%.1f", number);
    }

    public static String twoDecimalFormat(Double number) {
        return String.format("%.2f", number);
    }

    public static String formatMoneyKMBT(long value) {
        return Formatter.formatMoneyKMBT((double)value);
    }

    public static String formatMoneyKMBT(int value) {
        return Formatter.formatMoneyKMBT((double)value);
    }

    public static String formatMoneyKMBT(double value) {
        if (value == Double.MIN_VALUE) {
            return Formatter.formatMoneyKMBT(1.0);
        }
        if (value < 0.0) {
            return "-" + Formatter.formatMoneyKMBT(-value);
        }
        if (value < 1000.0) {
            return Integer.toString((int)value);
        }
        Map.Entry<Double, String> e = suffixes.floorEntry(value);
        Double divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = (long)(value / (divideBy / 10.0));
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static String formatTimeMMSS(long secs) {
        return Formatter.formatTimeMMSS((int)TimeUnit.MILLISECONDS.toSeconds(secs));
    }

    public static String formatTimeMMSS(int secs) {
        int seconds = secs % 60;
        long minutesCount = (secs -= seconds) / 60;
        long minutes = minutesCount % 60L;
        long hours = (minutesCount -= minutes) / 60L;
        return (hours > 0L ? (hours < 10L ? "0" : "") + hours + ":" : "") + (minutes < 10L ? "0" : "") + minutes + ":" + (seconds < 10 ? "0" : "") + seconds;
    }

    static {
        suffixes.put(1000.0, "k");
        suffixes.put(1000000.0, "M");
        suffixes.put(1.0E9, "B");
        suffixes.put(1.0E12, "T");
        suffixes.put(1.0E15, "QD");
        suffixes.put(1.0E18, "QT");
        suffixes.put(1.0E21, "SX");
        suffixes.put(1.0E24, "ST");
        suffixes.put(1.0E27, "O");
        suffixes.put(1.0E30, "N");
        suffixes.put(1.0E33, "D");
        suffixes.put(1.0E36, "U");
        suffixes.put(1.0E39, "DU");
        suffixes.put(1.0E42, "TD");
    }
}

