/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util;

public enum Duration {
    SECOND(1000L, "s"),
    MINUTE(60L * Duration.SECOND.duration, "m"),
    HOUR(60L * Duration.MINUTE.duration, "h"),
    DAY(24L * Duration.HOUR.duration, "d"),
    WEEK(7L * Duration.DAY.duration, "w"),
    MONTH(30L * Duration.DAY.duration, "M"),
    YEAR(365L * Duration.DAY.duration, "y");

    private final long duration;
    private final String name;

    private Duration(long duration, String name) {
        this.duration = duration;
        this.name = name;
    }

    public static Duration getByName(String name) {
        for (Duration duration : Duration.values()) {
            if (!duration.getName().equals(name)) continue;
            return duration;
        }
        return null;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getName() {
        return this.name;
    }
}

