/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util;

import com.google.common.base.Preconditions;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.time.FastDateFormat;

public class DateTimeFormats {
    private static final AtomicBoolean loaded = new AtomicBoolean(false);
    public static FastDateFormat DAY_MTH_HR_MIN_SECS;
    public static FastDateFormat DAY_MTH_YR_HR_MIN_AMPM;
    public static FastDateFormat DAY_MTH_HR_MIN_AMPM;
    public static FastDateFormat HR_MIN_AMPM;
    public static FastDateFormat HR_MIN_AMPM_TIMEZONE;
    public static FastDateFormat HR_MIN;
    public static FastDateFormat KOTH_FORMAT;
    public static final ThreadLocal<DecimalFormat> REMAINING_SECONDS;
    public static final ThreadLocal<DecimalFormat> REMAINING_SECONDS_TRAILING;

    private DateTimeFormats() {
    }

    public static void reload(TimeZone timeZone) throws IllegalStateException {
        Preconditions.checkArgument((!loaded.getAndSet(true) ? 1 : 0) != 0, (Object)"Already loaded");
        DAY_MTH_HR_MIN_SECS = FastDateFormat.getInstance((String)"dd/MM HH:mm:ss", (TimeZone)timeZone, (Locale)Locale.ENGLISH);
        DAY_MTH_YR_HR_MIN_AMPM = FastDateFormat.getInstance((String)"dd/MM/yy hh:mma", (TimeZone)timeZone, (Locale)Locale.ENGLISH);
        DAY_MTH_HR_MIN_AMPM = FastDateFormat.getInstance((String)"dd/MM hh:mma", (TimeZone)timeZone, (Locale)Locale.ENGLISH);
        HR_MIN_AMPM = FastDateFormat.getInstance((String)"hh:mma", (TimeZone)timeZone, (Locale)Locale.ENGLISH);
        HR_MIN_AMPM_TIMEZONE = FastDateFormat.getInstance((String)"hh:mma z", (TimeZone)timeZone, (Locale)Locale.ENGLISH);
        HR_MIN = FastDateFormat.getInstance((String)"hh:mm", (TimeZone)timeZone, (Locale)Locale.ENGLISH);
        KOTH_FORMAT = FastDateFormat.getInstance((String)"m:ss", (TimeZone)timeZone, (Locale)Locale.ENGLISH);
    }

    static {
        REMAINING_SECONDS = new ThreadLocal<DecimalFormat>(){

            @Override
            protected DecimalFormat initialValue() {
                return new DecimalFormat("0.#");
            }
        };
        REMAINING_SECONDS_TRAILING = new ThreadLocal<DecimalFormat>(){

            @Override
            protected DecimalFormat initialValue() {
                return new DecimalFormat("0.0");
            }
        };
    }
}

