/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static Set<Class<?>> getClassesInPackage(JavaPlugin plugin, String packageName, boolean isTopLevel) throws IOException {
        return ClassPath.from((ClassLoader)plugin.getClass().getProtectionDomain().getClassLoader()).getAllClasses().stream().filter(clazz -> clazz.getPackageName().equalsIgnoreCase(packageName)).filter(clazz -> isTopLevel && clazz.isTopLevel()).map(ClassPath.ClassInfo::load).collect(Collectors.toSet());
    }

    public static Collection<Class<?>> getClassesInPackage(Plugin plugin, String packageName) {
        JarFile jarFile;
        ArrayList classes = new ArrayList();
        CodeSource codeSource = plugin.getClass().getProtectionDomain().getCodeSource();
        URL resource = codeSource.getLocation();
        String relPath = packageName.replace('.', '/');
        String resPath = resource.getPath().replace("%20", " ");
        String jarPath = resPath.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
        try {
            jarFile = new JarFile(jarPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException reading JAR File '" + jarPath + "'", e);
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            String className = null;
            if (entryName.endsWith(".class") && entryName.startsWith(relPath) && entryName.length() > relPath.length() + "/".length()) {
                className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
            }
            if (className == null) continue;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (clazz == null) continue;
            classes.add(clazz);
        }
        try {
            jarFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ImmutableSet.copyOf(classes);
    }
}

