/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.timer;

import com.conaxgames.libraries.message.TimeUtil;
import com.conaxgames.libraries.timer.QuickTimerType;
import com.conaxgames.libraries.util.CC;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;

public class QuickTimerManager {
    public static HashMap<UUID, QuickTimerType> timerPlayersMap = new HashMap();

    public static void addTimer(UUID uuid, String ability, long time) {
        if (!timerPlayersMap.containsKey(uuid)) {
            timerPlayersMap.put(uuid, new QuickTimerType(uuid, System.currentTimeMillis() + time, false));
        }
        if (QuickTimerManager.hasTimer(uuid, ability)) {
            return;
        }
        QuickTimerManager.timerPlayersMap.get((Object)uuid).timerMap.put(ability, new QuickTimerType(uuid, System.currentTimeMillis() + time, false));
    }

    public static void addTimer(UUID uuid, String ability, long time, boolean announce) {
        if (!timerPlayersMap.containsKey(uuid)) {
            timerPlayersMap.put(uuid, new QuickTimerType(uuid, System.currentTimeMillis() + time, announce));
        }
        if (QuickTimerManager.hasTimer(uuid, ability)) {
            return;
        }
        QuickTimerManager.timerPlayersMap.get((Object)uuid).timerMap.put(ability, new QuickTimerType(uuid, System.currentTimeMillis() + time, announce));
    }

    public static void addTimer(Player player, String ability, long time) {
        UUID uuid = player.getUniqueId();
        if (!timerPlayersMap.containsKey(uuid)) {
            timerPlayersMap.put(uuid, new QuickTimerType(uuid, System.currentTimeMillis() + time, false));
        }
        if (QuickTimerManager.hasTimer(uuid, ability)) {
            return;
        }
        QuickTimerManager.timerPlayersMap.get((Object)uuid).timerMap.put(ability, new QuickTimerType(uuid, System.currentTimeMillis() + time, false));
    }

    public static void addTimer(Player player, String ability, long time, boolean announce) {
        UUID uuid = player.getUniqueId();
        if (!timerPlayersMap.containsKey(uuid)) {
            timerPlayersMap.put(uuid, new QuickTimerType(uuid, System.currentTimeMillis() + time, announce));
        }
        if (QuickTimerManager.hasTimer(uuid, ability)) {
            return;
        }
        QuickTimerManager.timerPlayersMap.get((Object)uuid).timerMap.put(ability, new QuickTimerType(uuid, System.currentTimeMillis() + time, announce));
    }

    public static boolean hasTimer(UUID uuid, String ability) {
        if (!timerPlayersMap.containsKey(uuid)) {
            return false;
        }
        if (!QuickTimerManager.timerPlayersMap.get((Object)uuid).timerMap.containsKey(ability)) {
            return false;
        }
        if (QuickTimerManager.getRemaining(uuid, ability) <= 0L) {
            QuickTimerManager.removeTimer(uuid, ability);
            return false;
        }
        return true;
    }

    public static boolean hasAndMessage(Player player, String ability) {
        if (QuickTimerManager.hasTimer(player, ability)) {
            long remaining = QuickTimerManager.getRemaining(player.getUniqueId(), ability);
            player.sendMessage(CC.RED + "You must wait " + CC.B_RED + TimeUtil.timeAsString(remaining) + CC.RED + " before doing this again.");
            return true;
        }
        return false;
    }

    public static boolean hasTimer(Player player, String ability) {
        UUID uuid = player.getUniqueId();
        if (!timerPlayersMap.containsKey(uuid)) {
            return false;
        }
        if (!QuickTimerManager.timerPlayersMap.get((Object)uuid).timerMap.containsKey(ability)) {
            return false;
        }
        if (QuickTimerManager.getRemaining(uuid, ability) <= 0L) {
            QuickTimerManager.removeTimer(uuid, ability);
            return false;
        }
        return true;
    }

    public static void removeTimer(UUID uuid, String ability) {
        if (!timerPlayersMap.containsKey(uuid)) {
            return;
        }
        if (!QuickTimerManager.timerPlayersMap.get((Object)uuid).timerMap.containsKey(ability)) {
            return;
        }
        QuickTimerType timerType = timerPlayersMap.get(uuid);
        timerType.getTimerMap().remove(ability);
    }

    public static void removeTimer(Player player, String ability) {
        UUID uuid = player.getUniqueId();
        if (!timerPlayersMap.containsKey(uuid)) {
            return;
        }
        if (!QuickTimerManager.timerPlayersMap.get((Object)uuid).timerMap.containsKey(ability)) {
            return;
        }
        QuickTimerType timerType = timerPlayersMap.get(uuid);
        timerType.getTimerMap().remove(ability);
    }

    public static long getRemaining(UUID key, String ability) {
        if (!timerPlayersMap.containsKey(key)) {
            return 0L;
        }
        if (!QuickTimerManager.timerPlayersMap.get((Object)key).timerMap.containsKey(ability)) {
            return 0L;
        }
        return QuickTimerManager.timerPlayersMap.get((Object)key).timerMap.get(ability).getTime() - System.currentTimeMillis();
    }

    public static void clearCacheCooldown() {
        if (timerPlayersMap.isEmpty()) {
            return;
        }
        for (UUID key : timerPlayersMap.keySet()) {
            for (String name : QuickTimerManager.timerPlayersMap.get((Object)key).timerMap.keySet()) {
                if (!((double)QuickTimerManager.getRemaining(key, name) < 0.0)) continue;
                QuickTimerManager.removeTimer(key, name);
            }
        }
    }
}

