/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.redis.pubsub.handler;

import com.conaxgames.libraries.redis.JedisConnection;
import com.conaxgames.libraries.redis.JedisCredentials;
import com.conaxgames.libraries.redis.message.MessageTypeEnum;
import com.conaxgames.libraries.redis.message.UniversalMessageTypeResolver;
import com.conaxgames.libraries.redis.pubsub.SubscribeObject;
import com.conaxgames.libraries.redis.subscription.generator.JsonJedisSubscriptionGenerator;
import com.conaxgames.libraries.redis.subscription.model.JedisSubscriptionGenerator;
import com.conaxgames.libraries.redis.subscription.model.JedisSubscriptionHandler;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public class JedisSubscriber<K> {
    private static final Map<Class<?>, JedisSubscriptionGenerator<?>> GENERATORS = new HashMap();
    protected final String channel;
    private final JedisConnection connection;
    private final Class<K> typeParameter;
    private final JedisCredentials jedisSettings;
    private final Jedis jedis;
    private JedisPubSub pubSub;
    private JedisSubscriptionHandler<K> jedisSubscriptionHandler;

    public JedisSubscriber(JedisConnection connection, JedisCredentials jedisSettings, String channel, final Class<K> typeParameter, JedisSubscriptionHandler<K> jedisSubscriptionHandler) {
        this.connection = connection;
        this.jedisSettings = jedisSettings;
        this.channel = channel;
        this.typeParameter = typeParameter;
        this.jedisSubscriptionHandler = jedisSubscriptionHandler;
        this.pubSub = new JedisPubSub(){

            @Override
            public void onMessage(String channel, String message) {
                JedisSubscriptionGenerator jedisSubscriptionGenerator = (JedisSubscriptionGenerator)GENERATORS.get(typeParameter);
                if (jedisSubscriptionGenerator != null) {
                    Object object = jedisSubscriptionGenerator.generateSubscription(message);
                    if (object instanceof JsonObject) {
                        UniversalMessageTypeResolver resolver = new UniversalMessageTypeResolver(MessageTypeEnum.class);
                        JedisSubscriber.this.jedisSubscriptionHandler.subscribe(object, new SubscribeObject().from((JsonObject)object, resolver));
                    } else {
                        JedisConnection.getInstance().toConsole("JedisSubscriber: Received object is not of type JsonObject");
                    }
                } else {
                    JedisConnection.getInstance().toConsole("JedisSubscriber: Jedis GENERATOR Type was invalid");
                }
            }
        };
        this.jedis = new Jedis(this.jedisSettings.getAddress(), this.jedisSettings.getPort());
        this.authenticate();
        this.attemptConnect();
    }

    private void authenticate() {
        if (this.jedisSettings.hasPassword()) {
            this.jedis.auth(this.jedisSettings.getPassword());
        }
    }

    private void attemptConnect() {
        new Thread(() -> {
            block4: {
                try {
                    this.jedis.subscribe(this.pubSub, this.channel);
                    this.connection.toConsole("JedisSubscriber: Jedis is now reading on " + this.channel);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!this.connection.isEnabled()) break block4;
                    this.connection.toConsole("JedisSubscriber: Jedis channel (" + this.channel + ") has lost connection...");
                    try {
                        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
                        scheduler.scheduleAtFixedRate(() -> {
                            JedisConnection jedisConnection = JedisConnection.getInstance();
                            jedisConnection.toConsole("JedisSubscriber: Attempting to reconnect JedisSubscriber (" + this.channel + ")");
                            this.closeConnection();
                            this.attemptConnect();
                            if (this.jedis != null && this.pubSub.isSubscribed()) {
                                jedisConnection.toConsole("JedisSubscriber: JedisSubscriber (" + this.channel + ") has reconnected");
                                scheduler.shutdown();
                            } else {
                                jedisConnection.toConsole("JedisSubscriber: JedisSubscriber (" + this.channel + ") will attempt a reconnect in 15 seconds...");
                            }
                        }, 10L, 10L, TimeUnit.SECONDS);
                    }
                    catch (IllegalArgumentException exception) {
                        this.connection.toConsole("Unable to define thread pool, can't start jedis-reconnect task...");
                    }
                }
            }
        }).start();
    }

    public void closeConnection() {
        try {
            if (this.pubSub != null) {
                this.pubSub.unsubscribe();
            }
            if (this.jedis != null) {
                this.jedis.close();
            }
        }
        catch (Exception e) {
            boolean pubSubConnected = this.pubSub != null && this.pubSub.isSubscribed();
            this.connection.toConsole("JedisSubscriber: Unable to close connection for (" + this.channel + ")... is it still connected? " + pubSubConnected);
        }
    }

    @Generated
    public JedisPubSub getPubSub() {
        return this.pubSub;
    }

    static {
        GENERATORS.put(JsonObject.class, new JsonJedisSubscriptionGenerator());
    }
}

