/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.redis.pubsub;

import com.conaxgames.libraries.redis.JedisConnection;
import com.conaxgames.libraries.redis.message.MessageTypeEnum;
import com.conaxgames.libraries.redis.message.MessageTypeInterface;
import com.conaxgames.libraries.redis.message.MessageTypeResolver;
import com.google.gson.JsonObject;
import lombok.Generated;

public class SubscribeObject {
    public MessageTypeInterface messageType = MessageTypeEnum.UNKNOWN;
    public String message = null;
    public String permission = null;
    public String destination = null;
    public String ipAddress = null;

    public SubscribeObject from(JsonObject object, MessageTypeResolver resolver) {
        if (object == null || !object.has("action")) {
            JedisConnection.getInstance().toConsole("Jedis Subscribe Object: Received JsonObject was null...");
            return null;
        }
        String action = object.get("action").getAsString();
        try {
            this.messageType = resolver.resolve(action);
        }
        catch (IllegalArgumentException e) {
            JedisConnection.getInstance().toConsole("Invalid action type: " + action);
            return null;
        }
        if (object.has("destination")) {
            this.destination = object.get("destination").getAsString();
            String localServer = JedisConnection.getInstance().getInstanceId();
            if (!this.destination.equalsIgnoreCase(localServer)) {
                return null;
            }
        }
        if (object.has("message")) {
            this.message = object.get("message").getAsString();
        }
        if (object.has("permission")) {
            this.permission = object.get("permission").getAsString();
        }
        if (object.has("ipAddress")) {
            this.ipAddress = object.get("ipAddress").getAsString();
        }
        return this;
    }

    @Generated
    public MessageTypeInterface getMessageType() {
        return this.messageType;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public String getDestination() {
        return this.destination;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }
}

