/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.redis.pubsub;

import com.conaxgames.libraries.redis.JedisConnection;
import com.google.gson.JsonObject;
import java.util.UUID;
import lombok.Generated;

public class PublishObject {
    public JsonObject object;

    public PublishObject(String messageType) {
        this.object = this.getBase(messageType);
    }

    public JsonObject build() {
        return this.object;
    }

    public JsonObject getBase(String messageType) {
        String serverName = JedisConnection.getInstance().getInstanceId();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("origin", serverName);
        jsonObject.addProperty("action", messageType);
        return jsonObject;
    }

    public JsonObject addTarget(UUID target) {
        if (target != null) {
            this.object.addProperty("target", target.toString());
        }
        return this.object;
    }

    public JsonObject addMessage(String message) {
        if (message != null) {
            this.object.addProperty("message", message);
        }
        return this.object;
    }

    public JsonObject addPermission(String permission) {
        if (permission != null) {
            this.object.addProperty("permission", permission);
        }
        return this.object;
    }

    public JsonObject addDestination(String destination) {
        if (destination != null) {
            this.object.addProperty("destination", destination);
        }
        return this.object;
    }

    public JsonObject addProperty(String key, String field) {
        if (key != null && field != null) {
            this.object.addProperty(key, field);
        }
        return this.object;
    }

    public JsonObject addProperty(String key, int field) {
        if (key != null) {
            this.object.addProperty(key, field);
        }
        return this.object;
    }

    public JsonObject addProperty(String key, boolean field) {
        if (key != null) {
            this.object.addProperty(key, field);
        }
        return this.object;
    }

    public JsonObject addProperty(String key, long field) {
        if (key != null) {
            this.object.addProperty(key, field);
        }
        return this.object;
    }

    public JsonObject addProperty(String key, double field) {
        if (key != null) {
            this.object.addProperty(key, field);
        }
        return this.object;
    }

    @Generated
    public PublishObject() {
    }
}

