/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.redis.pubsub;

import com.conaxgames.libraries.redis.JedisCredentials;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import redis.clients.jedis.Jedis;

public abstract class JedisListener {
    private final JedisCredentials jedisSettings;
    private final String channel;
    private final Object parameter;

    public JedisListener(JedisCredentials jedisSettings, String channel, Object parameter) {
        this.jedisSettings = jedisSettings;
        this.channel = channel;
        this.parameter = parameter == null ? new JsonObject() : parameter;
        this.listen();
    }

    public JedisListener(JedisCredentials jedisSettings, String channel) {
        this(jedisSettings, channel, null);
    }

    public abstract void respond(String var1, Object var2);

    private void listen() {
        new Thread(() -> {
            while (true) {
                Jedis jedis = null;
                try {
                    jedis = this.jedisSettings.getJedisPool().getResource();
                    try {
                        List<String> messages = jedis.blpop(0, this.channel);
                        if (this.parameter instanceof JsonObject) {
                            this.respond(messages.get(0), new JsonParser().parse(messages.get(1)).getAsJsonObject());
                            continue;
                        }
                        this.respond(messages.get(0), messages.get(1));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                finally {
                    if (jedis == null) continue;
                    jedis.close();
                    continue;
                }
                break;
            }
        }).start();
    }
}

