/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.redis;

import lombok.Generated;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisCredentials {
    private final String address;
    private final int port;
    private final String password;
    private final JedisPool jedisPool;

    public JedisCredentials(String address, int port, String password) {
        this(address, port, password, new JedisPoolConfig());
    }

    public JedisCredentials(String address, int port, String password, JedisPoolConfig config) {
        this.address = address;
        this.port = port;
        this.password = password;
        this.jedisPool = new JedisPool((GenericObjectPoolConfig<Jedis>)config, this.address, this.port, 0, this.password);
    }

    public JedisCredentials(String address, String password) {
        this(address, 6379, password);
    }

    public JedisCredentials(String address) {
        this(address, null);
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public JedisPool getJedisPool() {
        return this.jedisPool;
    }
}

