/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.module.type;

import com.conaxgames.libraries.LibraryPlugin;
import com.conaxgames.libraries.config.CommentedConfiguration;
import com.conaxgames.libraries.module.type.SubModule;
import com.conaxgames.libraries.util.Config;
import java.io.InputStream;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class Module {
    public LibraryPlugin library = LibraryPlugin.getInstance();
    public JavaPlugin javaPlugin;
    private Config settings;

    public Module(JavaPlugin javaPlugin) {
        this.javaPlugin = javaPlugin;
        this.settings = this.getResource();
    }

    public void reloadConfig() {
        this.settings = this.getResource();
    }

    public abstract String getName();

    public String getIdentifier() {
        return this.getName().toLowerCase();
    }

    public boolean isConfiguredToEnable() {
        if (this instanceof SubModule) {
            return true;
        }
        return this.getBoolean("enabled", false);
    }

    public String getRequiredPlugin() {
        return null;
    }

    public abstract String getDescription();

    public abstract String getAuthor();

    public abstract List<String> noSync();

    public abstract void setupFiles();

    public abstract void onEnable();

    public abstract void onReload();

    public abstract void onDisable();

    public boolean canRegister() {
        String requiredPlugin = this.getRequiredPlugin();
        if (requiredPlugin == null) {
            return true;
        }
        if (Bukkit.getPluginManager().getPlugin(requiredPlugin) == null) {
            this.library.getLibraryLogger().toConsole("ModuleManager", "Required plugin " + requiredPlugin + " is missing. Module " + this.getIdentifier() + " cannot be registered.", new Throwable[0]);
            return false;
        }
        return true;
    }

    public String getString(String path, String def) {
        return this.settings.getConfig().getString(path, def);
    }

    public int getInt(String path, int def) {
        return this.settings.getConfig().getInt(path, def);
    }

    public long getLong(String path, long def) {
        return this.settings.getConfig().getLong(path, def);
    }

    public double getDouble(String path, double def) {
        return this.settings.getConfig().getDouble(path, def);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.settings.getConfig().getBoolean(path, def);
    }

    public Object get(String path, Object def) {
        return this.settings.getConfig().get(path, def);
    }

    public ConfigurationSection getConfigSection(String path) {
        return this.settings.getConfig().getConfigurationSection(path);
    }

    public List<String> getStringList(String path) {
        return this.settings.getConfig().getStringList(path);
    }

    public void set(String path, Object value) {
        this.settings.set(path, value);
        this.getLibrary().getLibraryLogger().toConsole("Module", "Saved " + path + " as " + value + " in " + this.getIdentifier(), new Throwable[0]);
    }

    public Config getResource(boolean sync, boolean syncOnCreation) {
        return this.getResource("settings", sync, syncOnCreation);
    }

    public Config getResource() {
        return this.getResource("settings", true, true);
    }

    public Config getResource(@NonNull String destination, boolean forceSync, boolean syncOnCreation) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        String dest = destination.replace(".yml", "");
        Config config = new Config("/modules/" + this.getIdentifier() + "/" + dest, this.javaPlugin);
        if (config.getConfigFile() == null) {
            this.library.getLibraryLogger().toConsole("Module", "Configuration was null when attempting to getResource. (" + this.getIdentifier() + ", " + this.getJavaPlugin().getName() + ")", new Throwable[0]);
            return config;
        }
        InputStream fileStream = this.javaPlugin.getResource("modules/" + this.getIdentifier() + "/" + dest + ".yml");
        if (fileStream == null) {
            this.library.getLibraryLogger().toConsole("Module", "Input stream was null when attempting to getResource. (Id: " + this.getIdentifier() + ", JavaPlugin: " + this.getJavaPlugin().getName() + ")", new Throwable[0]);
            return config;
        }
        if (forceSync || config.isWasCreated() && syncOnCreation) {
            try {
                String[] dontSync = this.noSync() == null ? new String[]{} : this.noSync().toArray(new String[0]);
                CommentedConfiguration commentedConfiguration = CommentedConfiguration.loadConfiguration(config.getConfigFile());
                commentedConfiguration.syncWithConfig(config.getConfigFile(), fileStream, dontSync);
                this.library.getLibraryLogger().toConsole("Module", "Sync'd /modules/" + this.getIdentifier() + "/" + dest + ".yml with config.", new Throwable[0]);
            }
            catch (Exception exception) {
                this.library.getLibraryLogger().toConsole("Module", "Unable to sync /modules/" + this.getIdentifier() + "/" + dest + ".yml with config.", exception);
            }
        }
        return config;
    }

    public boolean isEnabled() {
        return LibraryPlugin.getInstance().getModuleManager().getStatus(this);
    }

    @Generated
    public LibraryPlugin getLibrary() {
        return this.library;
    }

    @Generated
    public JavaPlugin getJavaPlugin() {
        return this.javaPlugin;
    }

    @Generated
    public Config getSettings() {
        return this.settings;
    }

    @Generated
    public void setLibrary(LibraryPlugin library) {
        this.library = library;
    }

    @Generated
    public void setJavaPlugin(JavaPlugin javaPlugin) {
        this.javaPlugin = javaPlugin;
    }

    @Generated
    public void setSettings(Config settings) {
        this.settings = settings;
    }
}

