/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.module.manage;

import com.conaxgames.libraries.menu.Button;
import com.conaxgames.libraries.message.FormatUtil;
import com.conaxgames.libraries.module.ModuleManager;
import com.conaxgames.libraries.module.type.Module;
import com.conaxgames.libraries.util.CC;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class ModuleButton
extends Button {
    private final ModuleManager moduleManager;
    private final Module module;
    private final boolean enabled;

    public ModuleButton(ModuleManager moduleManager, Module module) {
        this.moduleManager = moduleManager;
        this.module = module;
        this.enabled = module.isEnabled();
    }

    @Override
    public String getName(Player var1) {
        return this.enabled ? CC.GREEN + this.module.getName() : CC.RED + this.module.getName();
    }

    @Override
    public List<String> getDescription(Player var1) {
        String ownedPlugin = this.module.getJavaPlugin() == null ? "Unknown" : this.module.getJavaPlugin().getName();
        ArrayList<String> description = new ArrayList<String>();
        description.add(CC.DARK_GRAY + ownedPlugin);
        description.add(" ");
        description.addAll(FormatUtil.wordWrap(CC.GRAY + this.module.getDescription()));
        description.add(" ");
        description.add(CC.GRAY + "Author: " + CC.WHITE + this.module.getAuthor());
        if (this.module.getRequiredPlugin() != null) {
            description.add(CC.GRAY + "Requires: " + CC.WHITE + this.module.getRequiredPlugin());
        }
        description.add(" ");
        description.add(CC.YELLOW + (this.enabled ? "Click to disable." : "Click to enable."));
        description.addAll(FormatUtil.wordWrap(CC.GRAY + "(Use a Shift-Click to not save this change over reboots)"));
        return description;
    }

    @Override
    public Material getMaterial(Player var1) {
        return this.enabled ? Material.LIME_DYE : Material.RED_DYE;
    }

    @Override
    public void clicked(Player player, int slot, ClickType clickType) {
        boolean persistent;
        boolean bl = persistent = !clickType.isShiftClick();
        if (this.enabled) {
            this.moduleManager.disableModule(this.module, persistent);
        } else {
            this.moduleManager.enableModule(this.module, persistent);
        }
        player.sendMessage(this.enabled ? CC.RED + "You have disabled " + this.module.getIdentifier() + CC.GRAY + " (saved: " + persistent + ")" : CC.GREEN + "You have enabled " + this.module.getIdentifier() + CC.GRAY + " (saved: " + persistent + ")");
    }
}

