/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.module;

import com.conaxgames.libraries.LibraryPlugin;
import com.conaxgames.libraries.acf.PaperCommandManager;
import com.conaxgames.libraries.module.ModuleCommands;
import com.conaxgames.libraries.module.type.Module;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ModuleManager {
    public LibraryPlugin library;
    public Map<String, Map.Entry<Module, Boolean>> modules = new HashMap<String, Map.Entry<Module, Boolean>>();

    public ModuleManager(LibraryPlugin library, String commandAlias, String commandPermission) {
        this.library = library;
        PaperCommandManager commandManager = this.library.getPaperCommandManager();
        commandManager.getCommandReplacements().addReplacements("moduleCommandAlias", commandAlias, "moduleCommandPermission", commandPermission);
        commandManager.registerCommand(new ModuleCommands(this));
    }

    public String registerModule(Module module) {
        if (!module.canRegister()) {
            String message = module.getIdentifier() + " cannot be registered as one of its required plugins cannot be found.";
            this.library.getLibraryLogger().toConsole("ModuleManager", message, new Throwable[0]);
            return message;
        }
        if (!this.modules.containsKey(module.getIdentifier().toLowerCase())) {
            this.modules.put(module.getIdentifier().toLowerCase(), new AbstractMap.SimpleEntry<Module, Boolean>(module, false));
        }
        if (module.isConfiguredToEnable()) {
            this.enableModule(module, false);
        }
        String message = "Registered " + module.getIdentifier() + "!";
        this.library.getLibraryLogger().toConsole("Module Manager", message, new Throwable[0]);
        return message;
    }

    public String enableModule(Module module, boolean save) {
        Validate.notNull((Object)module, (String)"Module can not be null");
        Validate.notNull((Object)module.getIdentifier(), (String)"Identifier can not be null");
        if (!this.isRegistered(module.getIdentifier())) {
            this.registerModule(module);
        }
        module.setupFiles();
        module.reloadConfig();
        this.setModuleEnabled(module);
        this.modules.put(module.getIdentifier().toLowerCase(), new AbstractMap.SimpleEntry<Module, Boolean>(module, true));
        if (save) {
            module.set("enabled", true);
        }
        String message = "Enabled " + module.getIdentifier() + "!";
        this.library.getLibraryLogger().toConsole("Module Manager", message, new Throwable[0]);
        return message;
    }

    public String reloadModule(Module module) {
        Validate.notNull((Object)module, (String)"Module can not be null");
        Validate.notNull((Object)module.getIdentifier(), (String)"Identifier can not be null");
        if (!module.isEnabled()) {
            return module.getIdentifier() + " was not enabled, so can't be reloaded.";
        }
        this.registerModule(module);
        module.setupFiles();
        module.reloadConfig();
        module.onReload();
        String message = "Reloaded " + module.getIdentifier() + "!";
        this.library.getLibraryLogger().toConsole("Module Manager", message, new Throwable[0]);
        return message;
    }

    public String disableModule(Module module, boolean save) {
        boolean isAlreadyRegistered = this.isRegistered(module.getIdentifier());
        if (!isAlreadyRegistered) {
            String message = "Cannot disable " + module.getIdentifier() + " as it is not registered...";
            this.library.getLibraryLogger().toConsole("Module Manager", message, new Throwable[0]);
            return message;
        }
        Map.Entry<Module, Boolean> moduleAndValue = this.modules.get(module.getIdentifier());
        if (!moduleAndValue.getValue().booleanValue()) {
            String message = module.getIdentifier() + " is not enabled, so you cannot disable it.";
            this.library.getLibraryLogger().toConsole("Module Manager", message, new Throwable[0]);
            return message;
        }
        this.setModuleDisabled(module);
        this.modules.put(module.getIdentifier().toLowerCase(), new AbstractMap.SimpleEntry<Module, Boolean>(module, false));
        if (save) {
            module.set("enabled", false);
        }
        String message = "Disabled " + module.getIdentifier() + "!";
        this.library.getLibraryLogger().toConsole("Module Manager", message, new Throwable[0]);
        return message;
    }

    public Set<String> getRegisteredIdentifiers() {
        return ImmutableSet.copyOf(this.modules.keySet());
    }

    public boolean isRegistered(String identifier) {
        return this.getRegisteredIdentifiers().stream().filter(id -> id.equalsIgnoreCase(identifier)).findFirst().orElse(null) != null;
    }

    public Map<String, Module> getModules() {
        return this.modules.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Module)((Map.Entry)entry.getValue()).getKey()));
    }

    public Module getModuleByIdentifier(String identifier) {
        Map.Entry<Module, Boolean> entry = this.modules.get(identifier.toLowerCase());
        if (entry == null) {
            return null;
        }
        if (entry.getKey() == null) {
            return null;
        }
        return entry.getKey();
    }

    public boolean getStatus(Module module) {
        if (!this.modules.containsKey(module.getIdentifier().toLowerCase())) {
            return false;
        }
        return this.modules.get(module.getIdentifier().toLowerCase()).getValue();
    }

    protected boolean setModuleEnabled(Module module) {
        try {
            boolean listener = false;
            if (module instanceof Listener) {
                listener = true;
                Bukkit.getPluginManager().registerEvents((Listener)module, (Plugin)module.getJavaPlugin());
            }
            module.onReload();
            module.onEnable();
            this.library.getLibraryLogger().toConsole("Module Manager", "Enabled the " + module.getName() + " module. (listener: " + listener + ")", new Throwable[0]);
            return true;
        }
        catch (Throwable t) {
            this.library.getLibraryLogger().toConsole("Module Manager", "Failed to enable module " + module.getName(), new Throwable[0]);
            t.printStackTrace();
            return false;
        }
    }

    protected boolean setModuleDisabled(Module module) {
        try {
            boolean listener = false;
            if (module instanceof Listener) {
                listener = true;
                HandlerList.unregisterAll((Listener)((Listener)module));
            }
            module.onDisable();
            this.library.getLibraryLogger().toConsole("Module Manager", "Disabled the " + module.getName() + " module. (listener: " + listener + ")", new Throwable[0]);
            return true;
        }
        catch (Throwable t) {
            this.library.getLibraryLogger().toConsole("Module Manager", "Failed to disable module " + module.getName(), new Throwable[0]);
            t.printStackTrace();
            return false;
        }
    }

    public void disableAllModules() {
        this.getModules().forEach((name, module) -> module.onDisable());
    }

    public void reloadAllModules() {
        this.getModules().forEach((name, module) -> this.reloadModule((Module)module));
    }

    @Generated
    public LibraryPlugin getLibrary() {
        return this.library;
    }
}

