/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.module;

import com.conaxgames.libraries.acf.BaseCommand;
import com.conaxgames.libraries.acf.CommandHelp;
import com.conaxgames.libraries.acf.annotation.CatchUnknown;
import com.conaxgames.libraries.acf.annotation.CommandAlias;
import com.conaxgames.libraries.acf.annotation.CommandCompletion;
import com.conaxgames.libraries.acf.annotation.CommandPermission;
import com.conaxgames.libraries.acf.annotation.Default;
import com.conaxgames.libraries.acf.annotation.Description;
import com.conaxgames.libraries.acf.annotation.HelpCommand;
import com.conaxgames.libraries.acf.annotation.Subcommand;
import com.conaxgames.libraries.module.ModuleManager;
import com.conaxgames.libraries.module.manage.ModuleMenu;
import com.conaxgames.libraries.module.type.Module;
import com.conaxgames.libraries.util.CC;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="modules_%moduleCommandAlias")
@CommandPermission(value="%moduleCommandPermission")
public class ModuleCommands
extends BaseCommand {
    private final ModuleManager moduleManager;

    public ModuleCommands(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    @Subcommand(value="list")
    @Description(value="Open the module management menu or lists the registered modules.")
    @CommandCompletion(value="@modules")
    public void onList(CommandSender sender) {
        if (sender instanceof Player) {
            new ModuleMenu().openMenu((Player)sender);
        } else {
            this.moduleManager.getModules().forEach((id, module) -> sender.sendMessage(id));
        }
    }

    @Subcommand(value="enable")
    @Description(value="Reload individual modules")
    @CommandCompletion(value="@modules")
    public void onEnable(CommandSender sender, Module module, boolean persistent) {
        String result = this.moduleManager.enableModule(module, persistent);
        sender.sendMessage(CC.PRIMARY + result);
    }

    @Subcommand(value="disable")
    @Description(value="Reload individual modules")
    @CommandCompletion(value="@modules")
    public void onDisable(CommandSender sender, Module module, boolean persistent) {
        String result = this.moduleManager.disableModule(module, persistent);
        sender.sendMessage(CC.PRIMARY + result);
    }

    @Subcommand(value="reload")
    @Description(value="Reload individual modules")
    @CommandCompletion(value="@modules")
    public void onReload(CommandSender sender, Module module) {
        String result = this.moduleManager.reloadModule(module);
        sender.sendMessage(CC.PRIMARY + result);
    }

    @Default
    @HelpCommand
    @CatchUnknown
    public void onHelp(CommandSender sender, CommandHelp help) {
        help.showHelp();
    }
}

