/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.message;

import com.conaxgames.libraries.util.DateTimeFormats;
import com.conaxgames.libraries.util.Duration;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DurationFormatUtils;

public final class TimeUtil {
    private static final long MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private static final long HOUR = TimeUnit.HOURS.toMillis(1L);

    private TimeUtil() {
        throw new RuntimeException("Cannot instantiate a utility class.");
    }

    public static Timestamp addDuration(long duration) {
        return TimeUtil.truncateTimestamp(new Timestamp(System.currentTimeMillis() + duration));
    }

    public static Timestamp truncateTimestamp(Timestamp timestamp) {
        if (timestamp.toLocalDateTime().getYear() > 2037) {
            timestamp.setYear(2037);
        }
        return timestamp;
    }

    public static Timestamp addDuration(Timestamp timestamp) {
        return TimeUtil.truncateTimestamp(new Timestamp(System.currentTimeMillis() + timestamp.getTime()));
    }

    public static Timestamp fromMillis(long millis) {
        return new Timestamp(millis);
    }

    public static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static long getCurrentMillis() {
        return System.currentTimeMillis();
    }

    public static long toMillis(String time) {
        if (time == null) {
            return -1L;
        }
        String type = time.substring(time.length() - 1, time.length());
        Duration duration = Duration.getByName(type);
        if (duration == null) {
            return -1L;
        }
        int rawTime = Integer.parseInt(time.substring(0, time.length() - 1));
        return (long)rawTime * duration.getDuration();
    }

    public static String millisToRoundedTime(long millis) {
        long seconds;
        long minutes;
        long hours;
        long days;
        long weeks;
        long months;
        long years;
        if ((years = (months = (weeks = (days = (hours = (minutes = (seconds = ++millis / 1000L) / 60L) / 60L) / 24L) / 7L) / 4L) / 12L) > 0L) {
            return years + " year" + (years == 1L ? "" : "s");
        }
        if (months > 0L) {
            return months + " month" + (months == 1L ? "" : "s");
        }
        if (weeks > 0L) {
            return weeks + " week" + (weeks == 1L ? "" : "s");
        }
        if (days > 0L) {
            return days + " day" + (days == 1L ? "" : "s");
        }
        if (hours > 0L) {
            return hours + " hour" + (hours == 1L ? "" : "s");
        }
        if (minutes > 0L) {
            return minutes + " minute" + (minutes == 1L ? "" : "s");
        }
        return seconds + " second" + (seconds == 1L ? "" : "s");
    }

    public static long parseTime(String time) {
        long totalTime = 0L;
        boolean found = false;
        Matcher matcher = Pattern.compile("\\d+\\D+").matcher(time);
        while (matcher.find()) {
            String type;
            String s = matcher.group();
            Long value = Long.parseLong(s.split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)")[0]);
            switch (type = s.split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)")[1]) {
                case "s": {
                    totalTime += value.longValue();
                    found = true;
                    break;
                }
                case "m": {
                    totalTime += value * 60L;
                    found = true;
                    break;
                }
                case "h": {
                    totalTime += value * 60L * 60L;
                    found = true;
                    break;
                }
                case "d": {
                    totalTime += value * 60L * 60L * 24L;
                    found = true;
                    break;
                }
                case "w": {
                    totalTime += value * 60L * 60L * 24L * 7L;
                    found = true;
                    break;
                }
                case "M": {
                    totalTime += value * 60L * 60L * 24L * 30L;
                    found = true;
                    break;
                }
                case "y": {
                    totalTime += value * 60L * 60L * 24L * 365L;
                    found = true;
                }
            }
        }
        return !found ? -1L : totalTime * 1000L;
    }

    public static String timeAsStringLongFormat(long timePeriod) {
        long millis = timePeriod;
        String output = "";
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        if (days > 1L) {
            output = output + days + " days ";
        } else if (days == 1L) {
            output = output + days + " day ";
        }
        if (hours > 1L) {
            output = output + hours + " hours ";
        } else if (hours == 1L) {
            output = output + hours + " hour ";
        }
        if (minutes > 1L) {
            output = output + minutes + " minutes ";
        } else if (minutes == 1L) {
            output = output + minutes + " minute ";
        }
        if (seconds > 1L) {
            output = output + seconds + " seconds ";
        } else if (seconds == 1L) {
            output = output + seconds + " second ";
        }
        return output;
    }

    public static String timeAsString(long timePeriod) {
        long millis = timePeriod;
        String output = "";
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        if (days > 1L) {
            output = output + days + "d ";
        } else if (days == 1L) {
            output = output + days + "d ";
        }
        if (hours > 1L) {
            output = output + hours + "h ";
        } else if (hours == 1L) {
            output = output + hours + "h ";
        }
        if (minutes > 1L) {
            output = output + minutes + "m ";
        } else if (minutes == 1L) {
            output = output + minutes + "m ";
        }
        if (seconds > 1L) {
            output = output + seconds + "s";
        } else if (seconds == 1L) {
            output = output + seconds + "s";
        }
        if (output.isEmpty()) {
            output = output + "0s";
        }
        return output;
    }

    public static String timeAsStringCondensed(long timePeriod) {
        long millis = timePeriod;
        String output = "";
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        millis -= TimeUnit.MINUTES.toMillis(minutes);
        if (days > 1L) {
            output = output + days + "d ";
        } else if (days == 1L) {
            output = output + days + "d ";
        }
        if (hours > 1L) {
            output = output + hours + "h ";
        } else if (hours == 1L) {
            output = output + hours + "h ";
        }
        if (minutes > 1L) {
            output = output + minutes + "m ";
        } else if (minutes == 1L) {
            output = output + minutes + "m ";
        }
        return output;
    }

    public static String getTimerRemaining(long millis, boolean milliseconds) {
        return TimeUtil.getTimerRemaining(millis, milliseconds, true);
    }

    public static String getTimerRemaining(long duration, boolean milliseconds, boolean trail) {
        if (milliseconds && duration < MINUTE) {
            return (trail ? DateTimeFormats.REMAINING_SECONDS_TRAILING : DateTimeFormats.REMAINING_SECONDS).get().format((double)duration * 0.001) + 's';
        }
        return DurationFormatUtils.formatDuration((long)duration, (String)((duration >= HOUR ? "HH:" : "") + "mm:ss"));
    }
}

