/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.message;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public final class FormatUtil
extends Enum<FormatUtil> {
    private static final Pattern FORMATTING;
    private static final TreeMap<Integer, String> ROMAN_NUMERALS;
    private static final /* synthetic */ FormatUtil[] $VALUES;

    public static FormatUtil[] values() {
        return (FormatUtil[])$VALUES.clone();
    }

    public static FormatUtil valueOf(String name) {
        return Enum.valueOf(FormatUtil.class, name);
    }

    public static String stripFormatting(String format) {
        if (format == null || format.trim().isEmpty()) {
            return "";
        }
        return format.replaceAll("(\u00a7|&)[0-9a-fklmor]", "");
    }

    public static String normalize(String format) {
        if (format == null || format.trim().isEmpty()) {
            return "";
        }
        return format.replaceAll("(\u00a7|&)([0-9a-fklmor])", "\u00a7$2");
    }

    public static List<String> wordWrap(String s) {
        return FormatUtil.wordWrap(s, 24, 24);
    }

    public static List<String> wordWrap(String s, int lineSize) {
        return FormatUtil.wordWrap(s, lineSize, lineSize);
    }

    public static List<String> wordWrap(String s, int firstSegment, int lineSize) {
        String format = FormatUtil.getFormat(s);
        if (format == null || !s.startsWith(format)) {
            format = "";
        }
        ArrayList<String> words = new ArrayList<String>();
        int numChars = firstSegment;
        int ix = 0;
        int jx = 0;
        while (ix < s.length() && (ix = s.indexOf(32, ix + 1)) != -1) {
            String subString = s.substring(jx, ix).trim();
            String f = FormatUtil.getFormat(subString);
            int chars = FormatUtil.stripFormatting(subString).length() + 1;
            if (chars < numChars) continue;
            if (f != null) {
                format = f;
            }
            if (subString.isEmpty()) continue;
            words.add(FormatUtil.withFormat(format, subString));
            numChars = lineSize;
            jx = ix + 1;
        }
        words.add(FormatUtil.withFormat(format, s.substring(jx).trim()));
        return words;
    }

    public static List<String> wordWrapStrict(String s, int lineLength) {
        ArrayList<String> lines = new ArrayList<String>();
        String format = FormatUtil.getFormat(s);
        if (format == null || !s.startsWith(format)) {
            format = "";
        }
        String[] words = s.split(" ");
        String line = "";
        for (String word : words) {
            String f;
            String test = FormatUtil.stripFormatting(line + " " + word).trim();
            if (test.length() <= lineLength) {
                line = line + (line.isEmpty() ? "" : " ") + word;
                continue;
            }
            if (line.isEmpty() || FormatUtil.stripFormatting(word).length() > lineLength) {
                f = FormatUtil.getFormat(word);
                String strip = FormatUtil.stripFormatting(word);
                do {
                    int len = Math.min(strip.length(), lineLength - line.length() - 1);
                    lines.add(FormatUtil.withFormat(format, line + (line.isEmpty() ? "" : " ") + strip.substring(0, len)));
                    strip = strip.substring(len);
                    if (f == null) continue;
                    format = f;
                } while (strip.length() > lineLength);
                line = strip;
                continue;
            }
            lines.add(FormatUtil.withFormat(format, line));
            f = FormatUtil.getFormat(line);
            if (f != null) {
                format = f;
            }
            line = word;
        }
        if (!line.isEmpty()) {
            lines.add(FormatUtil.withFormat(format, line));
        }
        return lines;
    }

    private static String withFormat(String format, String subString) {
        String sf = null;
        sf = !subString.startsWith("\u00a7") ? format + subString : subString;
        return sf;
    }

    private static String getFormat(String s) {
        Matcher m = FORMATTING.matcher(s);
        String format = null;
        if (m.matches() && m.group("format") != null) {
            format = m.group("format");
        }
        return format;
    }

    public static String join(List<String> list, String separator) {
        String joined = "";
        for (String s : list) {
            joined = joined + s + separator;
        }
        joined = !list.isEmpty() ? joined.substring(0, joined.length() - separator.length()) : joined;
        return joined;
    }

    public static List<String> prefix(List<String> list, String prefix) {
        ArrayList<String> prefixed = new ArrayList<String>(list.size());
        for (String s : list) {
            prefixed.add(prefix + s);
        }
        return prefixed;
    }

    public static String camelcase(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String part : name.split("[ _]")) {
            sb.append(Character.toUpperCase(part.charAt(0)));
            sb.append(part.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static String escape(String formatString) {
        String escaped = FormatUtil.normalize(formatString);
        escaped = escaped.replaceAll("\u00a7", "&");
        return escaped;
    }

    public static String possessiveString(String str) {
        return str + (str.endsWith("s") ? "'" : "'s");
    }

    public static String formatTps(double tps) {
        double roundedTps = Math.min(tps, 20.0);
        ChatColor color = tps > 18.0 ? ChatColor.GREEN : (tps > 16.0 ? ChatColor.YELLOW : ChatColor.RED);
        String asterisk = tps > 20.0 ? "*" : "";
        return color + asterisk + String.format("%.2f", roundedTps);
    }

    public static String toRoman(int number) {
        int l = ROMAN_NUMERALS.floorKey(number);
        if (number == l) {
            return ROMAN_NUMERALS.get(number);
        }
        return ROMAN_NUMERALS.get(l) + FormatUtil.toRoman(number - l);
    }

    public static String getItemName(ItemStack item) {
        return item.getType().toString().replace("_", "");
    }

    public static String andJoin(Collection<String> collection, boolean delimiterBeforeAnd) {
        return FormatUtil.andJoin(collection, delimiterBeforeAnd, ", ");
    }

    public static String andJoin(Collection<String> collection, boolean delimiterBeforeAnd, String delimiter) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        ArrayList<String> contents = new ArrayList<String>(collection);
        String last = (String)contents.remove(contents.size() - 1);
        StringBuilder builder = new StringBuilder(Joiner.on((String)delimiter).join(contents));
        if (delimiterBeforeAnd) {
            builder.append(delimiter);
        }
        return builder.append(collection.size() <= 1 ? "" : " and ").append(last).toString();
    }

    private static /* synthetic */ FormatUtil[] $values() {
        return new FormatUtil[0];
    }

    static {
        $VALUES = FormatUtil.$values();
        FORMATTING = Pattern.compile("^.*(?<format>(\u00a7[0-9a-fklmor])+).*");
        ROMAN_NUMERALS = new TreeMap();
        ROMAN_NUMERALS.put(1000, "M");
        ROMAN_NUMERALS.put(900, "CM");
        ROMAN_NUMERALS.put(500, "D");
        ROMAN_NUMERALS.put(400, "CD");
        ROMAN_NUMERALS.put(100, "C");
        ROMAN_NUMERALS.put(90, "XC");
        ROMAN_NUMERALS.put(50, "L");
        ROMAN_NUMERALS.put(40, "XL");
        ROMAN_NUMERALS.put(10, "X");
        ROMAN_NUMERALS.put(9, "IX");
        ROMAN_NUMERALS.put(5, "V");
        ROMAN_NUMERALS.put(4, "IV");
        ROMAN_NUMERALS.put(1, "I");
        ROMAN_NUMERALS.put(0, "");
    }
}

