/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.menu.pagination;

import com.conaxgames.libraries.event.impl.menu.MenuButtonJumpToEvent;
import com.conaxgames.libraries.menu.Button;
import com.conaxgames.libraries.menu.pagination.PaginatedMenu;
import com.conaxgames.libraries.util.CC;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class JumpToPageButton
extends Button {
    private int page;
    private PaginatedMenu menu;

    @ConstructorProperties(value={"page", "menu"})
    public JumpToPageButton(int page, PaginatedMenu menu) {
        this.page = page;
        this.menu = menu;
    }

    @Override
    public String getName(Player player) {
        return CC.SECONDARY + "Page " + this.page;
    }

    @Override
    public List<String> getDescription(Player player) {
        ArrayList<String> description = new ArrayList<String>();
        description.add(CC.PRIMARY + "Click to view!");
        return description;
    }

    @Override
    public Material getMaterial(Player player) {
        return Material.BOOK;
    }

    @Override
    public int getAmount(Player player) {
        return this.page;
    }

    @Override
    public void clicked(Player player, int i, ClickType clickType) {
        new MenuButtonJumpToEvent(player, this.menu, this).call();
        this.menu.modPage(player, this.page - this.menu.getPage());
    }
}

