/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.menu;

import com.conaxgames.libraries.LibraryPlugin;
import com.conaxgames.libraries.event.impl.menu.MenuOpenEvent;
import com.conaxgames.libraries.menu.Button;
import com.conaxgames.libraries.menu.ButtonListener;
import com.conaxgames.libraries.util.CC;
import com.conaxgames.libraries.util.ItemFlagHelper;
import com.conaxgames.libraries.xseries.XMaterial;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Menu {
    private final ConcurrentHashMap<Integer, Button> buttons = new ConcurrentHashMap();
    private boolean autoUpdate = false;
    private boolean updateAfterClick = true;
    private boolean placeholder = false;
    private boolean hideItemAttributes = true;
    private boolean noncancellingInventory = false;
    private String staticTitle = null;
    private Menu previous;
    public static Map<String, Menu> currentlyOpenedMenus;
    public static Map<String, BukkitRunnable> checkTasks;
    private final Map<String, Inventory> openInventories = new HashMap<String, Inventory>();

    public Menu() {
    }

    public Menu(String staticTitle) {
        this.staticTitle = (String)Preconditions.checkNotNull((Object)staticTitle, (Object)"Menu title cannot be null");
    }

    private Inventory createInventory(Player player) {
        Map<Integer, Button> invButtons = this.getButtons(player);
        int size = this.size(invButtons);
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)size, (String)this.getTitle(player));
        for (Map.Entry<Integer, Button> buttonEntry : invButtons.entrySet()) {
            this.buttons.put(buttonEntry.getKey(), buttonEntry.getValue());
            if (buttonEntry.getKey() > size) continue;
            try {
                inv.setItem(buttonEntry.getKey().intValue(), buttonEntry.getValue().getButtonItem(player));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LibraryPlugin.getInstance().getLibraryLogger().toConsole("Menu", "An item slot in the " + this.staticTitle + " menu was invalid.", e);
            }
        }
        if (this.isPlaceholder()) {
            Button placeholder = Button.placeholder(XMaterial.GRAY_STAINED_GLASS_PANE.parseMaterial(), (byte)7, CC.DARK_GRAY + "");
            for (int index = 0; index < size; ++index) {
                if (invButtons.get(index) != null) continue;
                this.buttons.put(index, placeholder);
                inv.setItem(index, placeholder.getButtonItem(player));
            }
        }
        if (this.isHideItemAttributes()) {
            for (ItemStack item : inv.getContents()) {
                ItemMeta itemMeta;
                if (item == null || (itemMeta = item.getItemMeta()) == null) continue;
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlagHelper.getHideTooltipFlag()});
                item.setItemMeta(itemMeta);
            }
        }
        return inv;
    }

    public void openMenu(Player player) {
        this.openMenu(player, true);
    }

    public void openMenu(Player player, boolean firstOpen) {
        MenuOpenEvent openEvent;
        if (firstOpen && (openEvent = new MenuOpenEvent(player, this)).call()) {
            return;
        }
        if (Bukkit.isPrimaryThread()) {
            this.open(player);
        } else {
            Bukkit.getScheduler().runTask((Plugin)LibraryPlugin.getInstance().getPlugin(), () -> this.open(player));
        }
    }

    private void open(Player player) {
        Inventory inv = this.createInventory(player);
        this.openInventories.put(player.getName(), inv);
        player.openInventory(inv);
        this.update(player, inv);
    }

    public void buttonUpdate(Player player) {
        Inventory inv = this.openInventories.get(player.getName());
        if (inv != null) {
            inv.setContents(this.createInventory(player).getContents());
        }
    }

    private void update(final Player player, final Inventory inv) {
        Menu.cancelCheck(player);
        currentlyOpenedMenus.put(player.getName(), this);
        this.onOpen(player);
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                if (!player.isOnline()) {
                    Menu.cancelCheck(player);
                    currentlyOpenedMenus.remove(player.getName());
                    return;
                }
                if (Menu.this.isAutoUpdate()) {
                    inv.setContents(Menu.this.createInventory(player).getContents());
                }
            }
        };
        runnable.runTaskTimer((Plugin)LibraryPlugin.getInstance().getPlugin(), 10L, 20L);
        checkTasks.put(player.getName(), runnable);
    }

    public static void cancelCheck(Player player) {
        if (checkTasks.containsKey(player.getName())) {
            checkTasks.remove(player.getName()).cancel();
        }
    }

    public int size(Map<Integer, Button> buttons) {
        int highest = 0;
        for (int buttonValue : buttons.keySet()) {
            if (buttonValue <= highest) continue;
            highest = buttonValue;
        }
        return Math.min(54, (int)(Math.ceil((double)(highest + 1) / 9.0) * 9.0));
    }

    public int getSlot(int x, int y) {
        return 9 * y + x;
    }

    public String getTitle(Player player) {
        return this.staticTitle;
    }

    public abstract Map<Integer, Button> getButtons(Player var1);

    public void onOpen(Player player) {
    }

    public void onClose(Player player) {
        this.openInventories.remove(player.getName());
    }

    public Integer getBorderedIndex(int index) {
        index = index == 7 || index == 16 || index == 25 || index == 34 || index == 43 || index == 52 || index == 61 ? (index += 3) : ++index;
        return index;
    }

    public Integer getBorderedSize(int listSize) {
        return (int)Math.max(27.0, Math.min(Math.ceil((double)listSize / 7.0) + 2.0, 6.0) * 9.0);
    }

    @Generated
    public ConcurrentHashMap<Integer, Button> getButtons() {
        return this.buttons;
    }

    @Generated
    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    @Generated
    public boolean isUpdateAfterClick() {
        return this.updateAfterClick;
    }

    @Generated
    public boolean isPlaceholder() {
        return this.placeholder;
    }

    @Generated
    public boolean isHideItemAttributes() {
        return this.hideItemAttributes;
    }

    @Generated
    public boolean isNoncancellingInventory() {
        return this.noncancellingInventory;
    }

    @Generated
    public String getStaticTitle() {
        return this.staticTitle;
    }

    @Generated
    public Menu getPrevious() {
        return this.previous;
    }

    @Generated
    public Map<String, Inventory> getOpenInventories() {
        return this.openInventories;
    }

    @Generated
    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    @Generated
    public void setUpdateAfterClick(boolean updateAfterClick) {
        this.updateAfterClick = updateAfterClick;
    }

    @Generated
    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
    }

    @Generated
    public void setHideItemAttributes(boolean hideItemAttributes) {
        this.hideItemAttributes = hideItemAttributes;
    }

    @Generated
    public void setNoncancellingInventory(boolean noncancellingInventory) {
        this.noncancellingInventory = noncancellingInventory;
    }

    @Generated
    public void setStaticTitle(String staticTitle) {
        this.staticTitle = staticTitle;
    }

    @Generated
    public void setPrevious(Menu previous) {
        this.previous = previous;
    }

    static {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new ButtonListener(), (Plugin)LibraryPlugin.getInstance().getPlugin());
        currentlyOpenedMenus = new HashMap<String, Menu>();
        checkTasks = new HashMap<String, BukkitRunnable>();
    }
}

