/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.menu;

import com.conaxgames.libraries.LibraryPlugin;
import com.conaxgames.libraries.event.impl.menu.MenuBackEvent;
import com.conaxgames.libraries.event.impl.menu.MenuCloseEvent;
import com.conaxgames.libraries.menu.Button;
import com.conaxgames.libraries.menu.Menu;
import com.conaxgames.libraries.util.TaskUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ButtonListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onButtonPress(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Menu openMenu = Menu.currentlyOpenedMenus.get(player.getName());
        if (openMenu != null) {
            if (!openMenu.isNoncancellingInventory() && event.getClickedInventory() != null && event.getClickedInventory().getHolder() instanceof Player) {
                event.setCancelled(true);
            }
            if (event.getSlot() != event.getRawSlot()) {
                if (event.getClick().equals((Object)ClickType.DOUBLE_CLICK) || event.getClick().equals((Object)ClickType.NUMBER_KEY)) {
                    event.setCancelled(true);
                }
                if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT) {
                    event.setCancelled(true);
                    if (openMenu.isNoncancellingInventory() && event.getCurrentItem() != null) {
                        player.getOpenInventory().getTopInventory().addItem(new ItemStack[]{event.getCurrentItem()});
                        event.setCurrentItem(null);
                    } else if (event.getCurrentItem() != null) {
                        event.setCancelled(true);
                    }
                }
                return;
            }
            if (openMenu.getButtons().containsKey(event.getSlot())) {
                Menu newMenu;
                Button button = openMenu.getButtons().get(event.getSlot());
                boolean cancel = button.shouldCancel(player, event.getSlot(), event.getClick());
                if (!(cancel || event.getClick() != ClickType.SHIFT_LEFT && event.getClick() != ClickType.SHIFT_RIGHT)) {
                    event.setCancelled(true);
                    if (event.getCurrentItem() != null) {
                        player.getInventory().addItem(new ItemStack[]{event.getCurrentItem()});
                    }
                } else {
                    event.setCancelled(cancel);
                }
                button.clicked(player, event.getSlot(), event.getClick());
                if (Menu.currentlyOpenedMenus.containsKey(player.getName()) && (newMenu = Menu.currentlyOpenedMenus.get(player.getName())) == openMenu && newMenu.isUpdateAfterClick()) {
                    newMenu.buttonUpdate(player);
                    event.setCancelled(cancel);
                }
                if (event.isCancelled()) {
                    Bukkit.getScheduler().runTaskLater((Plugin)LibraryPlugin.getInstance().getPlugin(), () -> ((Player)player).updateInventory(), 1L);
                }
            } else if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT) {
                event.setCancelled(true);
                if (openMenu.isNoncancellingInventory() && event.getCurrentItem() != null) {
                    player.getOpenInventory().getTopInventory().addItem(new ItemStack[]{event.getCurrentItem()});
                    event.setCurrentItem(null);
                } else if (event.getCurrentItem() != null) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        Menu openMenu = Menu.currentlyOpenedMenus.get(player.getName());
        if (openMenu != null) {
            TaskUtil.runLater(() -> {
                Menu newMenu = Menu.currentlyOpenedMenus.get(player.getName());
                if (openMenu.getPrevious() != null) {
                    MenuBackEvent backEvent = new MenuBackEvent(player, openMenu, openMenu.getPrevious());
                    backEvent.call();
                    if (!backEvent.isCancelled() && newMenu == null) {
                        openMenu.getPrevious().openMenu(player);
                    }
                } else if (newMenu == null) {
                    new MenuCloseEvent(player, openMenu).call();
                }
            }, 2L);
            openMenu.onClose(player);
            Menu.cancelCheck(player);
            Menu.currentlyOpenedMenus.remove(player.getName());
        }
    }
}

