/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.inventoryui;

import com.conaxgames.libraries.LibraryPlugin;
import com.conaxgames.libraries.util.CC;
import com.conaxgames.libraries.util.ItemUtil;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

@Deprecated
public class InventoryUI {
    private final List<Inventory2D> inventories = new LinkedList<Inventory2D>();
    private final String title;
    private final int rowOffset;
    private final int rows;
    private int offset;
    private int page;

    public InventoryUI(String title, int rows) {
        this(title, rows, 0);
    }

    public InventoryUI(String title, int rows, int rowOffset) {
        this.title = title;
        this.rows = rows;
        this.rowOffset = rowOffset;
    }

    public Inventory2D getCurrentUI() {
        return this.inventories.get(this.page);
    }

    public Inventory getCurrentPage() {
        if (this.inventories.size() == 0) {
            this.createNewInventory();
        }
        return this.inventories.get(this.page).toInventory();
    }

    public ClickableItem getItem(int slot) {
        if (this.inventories.size() == 0) {
            this.createNewInventory();
        }
        Inventory2D lastInventory = this.inventories.get(this.inventories.size() - 1);
        return lastInventory.getItem(slot);
    }

    public int getSize() {
        return this.rows * 9;
    }

    private void createNewInventory() {
        Inventory2D inventory = new Inventory2D(this.title, this.rows, this.rowOffset);
        if (this.inventories.size() > 0) {
            inventory.setItem(0, this.rows - 1, new AbstractClickableItem(ItemUtil.createItem(Material.ARROW, CC.RED + "Page #" + this.inventories.size())){

                @Override
                public void onClick(InventoryClickEvent event) {
                    InventoryUI.this.page--;
                    try {
                        Inventory2D inventory2D = (Inventory2D)InventoryUI.this.inventories.get(InventoryUI.this.page);
                        if (inventory2D == null) {
                            InventoryUI.this.page++;
                        } else {
                            event.getWhoClicked().openInventory(InventoryUI.this.getCurrentPage());
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        InventoryUI.this.page++;
                    }
                }
            });
            if (inventory.currentY == this.rows - 1 && inventory.currentX == -1) {
                inventory.currentX++;
            }
        }
        this.inventories.add(inventory);
    }

    public void setItem(int x, int y, ClickableItem item) {
        if (this.inventories.size() == 0) {
            this.createNewInventory();
        }
        Inventory2D lastInventory = this.inventories.get(this.inventories.size() - 1);
        lastInventory.setItem(x - 1, y - 1, item);
    }

    public void setItem(int slot, ClickableItem item) {
        if (this.inventories.size() == 0) {
            this.createNewInventory();
        }
        Inventory2D lastInventory = this.inventories.get(this.inventories.size() - 1);
        lastInventory.setItem(slot, item);
    }

    public void addItem(ClickableItem item) {
        Inventory2D lastInventory;
        if (this.inventories.size() == 0) {
            this.createNewInventory();
        }
        if ((lastInventory = this.inventories.get(this.inventories.size() - 1)).currentY == this.rows - 1 && lastInventory.currentX >= 7 - this.offset) {
            lastInventory.setItem(8, this.rows - 1, new AbstractClickableItem(ItemUtil.createItem(Material.ARROW, CC.RED + "Page #" + (this.inventories.size() + 1))){

                @Override
                public void onClick(InventoryClickEvent event) {
                    InventoryUI.this.page++;
                    try {
                        Inventory2D inventory2D = (Inventory2D)InventoryUI.this.inventories.get(InventoryUI.this.page);
                        if (inventory2D == null) {
                            InventoryUI.this.page--;
                        } else {
                            event.getWhoClicked().openInventory(InventoryUI.this.getCurrentPage());
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        InventoryUI.this.page--;
                    }
                }
            });
            this.createNewInventory();
            this.addItem(item);
        } else {
            lastInventory.setItem(++lastInventory.currentX + this.offset, lastInventory.currentY, item);
        }
        if (lastInventory.currentX >= 8 - this.offset) {
            lastInventory.currentX = this.offset - 1;
            lastInventory.currentY++;
        }
    }

    public void addItem(AbstractClickableItem item) {
        Inventory2D lastInventory;
        if (this.inventories.size() == 0) {
            this.createNewInventory();
        }
        if ((lastInventory = this.inventories.get(this.inventories.size() - 1)).currentY == this.rows - 1 && lastInventory.currentX >= 7 - this.offset) {
            lastInventory.setItem(8, this.rows - 1, new AbstractClickableItem(ItemUtil.createItem(Material.ARROW, CC.RED + "Page #" + (this.inventories.size() + 1))){

                @Override
                public void onClick(InventoryClickEvent event) {
                    InventoryUI.this.page++;
                    try {
                        Inventory2D inventory2D = (Inventory2D)InventoryUI.this.inventories.get(InventoryUI.this.page);
                        if (inventory2D == null) {
                            InventoryUI.this.page--;
                        } else {
                            event.getWhoClicked().openInventory(InventoryUI.this.getCurrentPage());
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        InventoryUI.this.page--;
                    }
                }
            });
            this.createNewInventory();
            this.addItem(item);
        } else {
            lastInventory.setItem(++lastInventory.currentX + this.offset, lastInventory.currentY, item);
        }
        if (lastInventory.currentX >= 8 - this.offset) {
            lastInventory.currentX = this.offset - 1;
            lastInventory.currentY++;
        }
    }

    public void addItem(EmptyClickableItem item) {
        Inventory2D lastInventory;
        if (this.inventories.size() == 0) {
            this.createNewInventory();
        }
        if ((lastInventory = this.inventories.get(this.inventories.size() - 1)).currentY == this.rows - 1 && lastInventory.currentX >= 7 - this.offset) {
            lastInventory.setItem(8, this.rows - 1, new AbstractClickableItem(ItemUtil.createItem(Material.ARROW, CC.RED + "Page #" + (this.inventories.size() + 1))){

                @Override
                public void onClick(InventoryClickEvent event) {
                    InventoryUI.this.page++;
                    try {
                        Inventory2D inventory2D = (Inventory2D)InventoryUI.this.inventories.get(InventoryUI.this.page);
                        if (inventory2D == null) {
                            InventoryUI.this.page--;
                        } else {
                            event.getWhoClicked().openInventory(InventoryUI.this.getCurrentPage());
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        InventoryUI.this.page--;
                    }
                }
            });
            this.createNewInventory();
            this.addItem(item);
        } else {
            lastInventory.setItem(++lastInventory.currentX + this.offset, lastInventory.currentY, item);
        }
        if (lastInventory.currentX >= 8 - this.offset) {
            lastInventory.currentX = this.offset - 1;
            lastInventory.currentY++;
        }
    }

    public void addItemWithoutPages(EmptyClickableItem item) {
        if (this.inventories.size() == 0) {
            this.createNewInventory();
        }
        Inventory2D lastInventory = this.inventories.get(this.inventories.size() - 1);
        lastInventory.setItem(++lastInventory.currentX + this.offset, lastInventory.currentY, item);
        if (lastInventory.currentX >= 8 - this.offset) {
            lastInventory.currentX = this.offset - 1;
            lastInventory.currentY++;
        }
    }

    public void addItemWithoutPages(AbstractClickableItem item) {
        if (this.inventories.size() == 0) {
            this.createNewInventory();
        }
        Inventory2D lastInventory = this.inventories.get(this.inventories.size() - 1);
        lastInventory.setItem(++lastInventory.currentX + this.offset, lastInventory.currentY, item);
        if (lastInventory.currentX >= 8 - this.offset) {
            lastInventory.currentX = this.offset - 1;
            lastInventory.currentY++;
        }
    }

    public void removeItem(int slot) {
        Inventory2D inventory2D = this.inventories.get(this.page);
        this.setItem(slot, null);
        for (int i = slot + 1; i < this.getSize(); ++i) {
            ClickableItem item = this.getItem(i);
            this.setItem(i - 1, item);
            this.setItem(i, null);
        }
        if (inventory2D.currentX >= 0) {
            inventory2D.currentX--;
        } else if (inventory2D.currentY > 0) {
            inventory2D.currentY--;
            inventory2D.currentX = 7;
        }
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public int getRowOffset() {
        return this.rowOffset;
    }

    @Generated
    public int getRows() {
        return this.rows;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public List<Inventory2D> getInventories() {
        return this.inventories;
    }

    @Generated
    public void setOffset(int offset) {
        this.offset = offset;
    }

    public class Inventory2D {
        private final ClickableItem[][] items;
        private final String title;
        private final int rows;
        private Inventory cachedInventory;
        private int currentX = -1;
        private int currentY;

        public Inventory2D(String title, int rows, int rowOffset) {
            this.currentY = rowOffset;
            this.title = title;
            this.rows = rows;
            this.items = new ClickableItem[9][this.rows];
        }

        public void setItem(int x, int y, ClickableItem clickableItem) {
            this.items[x][y] = clickableItem;
            if (this.cachedInventory != null) {
                int slot = y * 9 + x;
                this.cachedInventory.setItem(slot, clickableItem != null ? clickableItem.getItemStack() : null);
            }
        }

        public void setItem(int slot, ClickableItem clickableItem) {
            int y = Math.abs(slot / 9);
            int x = -(y * 9 - slot);
            this.setItem(x, y, clickableItem);
        }

        public ClickableItem getItem(int slot) {
            int y = Math.abs(slot / 9);
            int x = -(y * 9 - slot);
            if (this.items.length <= x) {
                return null;
            }
            ClickableItem[] items = this.items[x];
            if (items.length <= y) {
                return null;
            }
            return items[y];
        }

        public Inventory toInventory() {
            if (this.cachedInventory != null) {
                return this.cachedInventory;
            }
            Inventory inventory = LibraryPlugin.getInstance().getPlugin().getServer().createInventory((InventoryHolder)new InventoryUIHolder(InventoryUI.this, this.title, this.rows * 9), this.rows * 9, this.title);
            for (int y = 0; y < this.rows; ++y) {
                for (int x = 0; x < 9; ++x) {
                    int slot = y * 9 + x;
                    ClickableItem item = this.items[x][y];
                    if (item == null) continue;
                    inventory.setItem(slot, item.getItemStack());
                }
            }
            this.cachedInventory = inventory;
            return inventory;
        }

        @Generated
        public ClickableItem[][] getItems() {
            return this.items;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public int getRows() {
            return this.rows;
        }

        @Generated
        public Inventory getCachedInventory() {
            return this.cachedInventory;
        }

        @Generated
        public int getCurrentX() {
            return this.currentX;
        }

        @Generated
        public int getCurrentY() {
            return this.currentY;
        }
    }

    public static interface ClickableItem {
        public void onClick(InventoryClickEvent var1);

        public ItemStack getItemStack();

        public void setItemStack(ItemStack var1);

        public ItemStack getDefaultItemStack();
    }

    public static abstract class AbstractClickableItem
    implements ClickableItem {
        private final ItemStack defaultItemStack;
        private ItemStack itemStack;

        public AbstractClickableItem(ItemStack itemStack) {
            this.itemStack = itemStack;
            this.defaultItemStack = itemStack;
        }

        @Override
        @Generated
        public ItemStack getDefaultItemStack() {
            return this.defaultItemStack;
        }

        @Override
        @Generated
        public ItemStack getItemStack() {
            return this.itemStack;
        }

        @Override
        @Generated
        public void setItemStack(ItemStack itemStack) {
            this.itemStack = itemStack;
        }
    }

    public static class EmptyClickableItem
    implements ClickableItem {
        private final ItemStack defaultItemStack;
        private ItemStack itemStack;

        public EmptyClickableItem(ItemStack itemStack) {
            this.itemStack = itemStack;
            this.defaultItemStack = itemStack;
        }

        @Override
        public void onClick(InventoryClickEvent event) {
        }

        @Override
        @Generated
        public ItemStack getDefaultItemStack() {
            return this.defaultItemStack;
        }

        @Override
        @Generated
        public ItemStack getItemStack() {
            return this.itemStack;
        }

        @Override
        @Generated
        public void setItemStack(ItemStack itemStack) {
            this.itemStack = itemStack;
        }
    }

    public static class InventoryUIHolder
    implements InventoryHolder {
        private InventoryUI inventoryUI;
        private String title;
        private int slots;

        private InventoryUIHolder(InventoryUI inventoryUI, String title, int slots) {
            this.inventoryUI = inventoryUI;
            this.title = title;
            this.slots = slots;
        }

        public Inventory getInventory() {
            return this.inventoryUI.getCurrentPage();
        }

        @Generated
        public InventoryUI getInventoryUI() {
            return this.inventoryUI;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public int getSlots() {
            return this.slots;
        }
    }
}

