/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.hooks;

import com.conaxgames.libraries.LibraryPlugin;
import com.conaxgames.libraries.event.impl.LibraryPluginEnableEvent;
import com.conaxgames.libraries.hooks.Hook;
import com.conaxgames.libraries.hooks.HookType;
import com.conaxgames.libraries.hooks.HookWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class HookManager
implements Listener {
    public LibraryPlugin plugin;
    public Set<Hook> hooks = new HashSet<Hook>();
    public Set<Hook> disabledHooks = new HashSet<Hook>();

    public HookManager(LibraryPlugin plugin) {
        this.plugin = plugin;
        for (Plugin p : plugin.getPlugin().getServer().getPluginManager().getPlugins()) {
            HookType type = Arrays.stream(HookType.values()).filter(t -> t.name().equalsIgnoreCase(p.getName())).findFirst().orElse(null);
            if (type == null) continue;
            this.registerHook(new HookWrapper(type, p));
        }
    }

    @EventHandler
    public void onPluginEnable(LibraryPluginEnableEvent event) {
        block0: for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            for (Hook disabled : this.disabledHooks) {
                if (!plugin.isEnabled() || !plugin.getName().contains(disabled.getPluginFromAnnotation())) continue;
                this.hooks.add(disabled);
                this.disabledHooks.remove(disabled);
                continue block0;
            }
        }
    }

    public void registerHook(Hook hook) {
        try {
            this.hooks.add(hook);
            if (LibraryPlugin.getInstance().getSettings().debug) {
                LibraryPlugin.getInstance().getLibraryLogger().toConsole("Hook Manager", "Hooked into " + (Object)((Object)hook.getHookType()) + " version " + hook.getPlugin().getDescription().getVersion() + ". (" + hook.getPlugin().getDescription().getDescription() + ")", new Throwable[0]);
            }
        }
        catch (Exception e) {
            this.plugin.getPlugin().getLogger().info("[cLibraries] Unable to load hook " + hook.getHookType().name() + " because of exception: ");
            e.printStackTrace();
        }
    }

    public List<Plugin> getDepends() {
        Plugin[] bukkitPluginList;
        ArrayList<Plugin> libraryPluginList = new ArrayList<Plugin>();
        for (Plugin plugin : bukkitPluginList = Bukkit.getPluginManager().getPlugins()) {
            if (!plugin.getDescription().getDepend().contains("cLibraries")) continue;
            libraryPluginList.add(plugin);
        }
        return libraryPluginList;
    }

    public Hook getHookByPluginName(String pluginName) {
        return this.getHooks().stream().filter(hook -> hook.getPluginFromAnnotation().equals(pluginName)).findFirst().orElse(null);
    }

    public Hook getHookByType(HookType type) {
        return this.getHooks().stream().filter(hook -> hook.getHookType().equals((Object)type)).findFirst().orElse(null);
    }

    public boolean isHooked(HookType type) {
        return this.getHookByType(type) != null;
    }

    public LibraryPlugin getPlugin() {
        return this.plugin;
    }

    public Set<Hook> getHooks() {
        return this.hooks;
    }

    public Set<Hook> getDisabledHooks() {
        return this.disabledHooks;
    }
}

