/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.config.core.model;

import com.conaxgames.libraries.LibraryPlugin;
import com.conaxgames.libraries.config.core.CoreMenu;
import com.conaxgames.libraries.config.core.model.ConfigButtonData;
import com.conaxgames.libraries.config.core.model.ConfigMenuData;
import com.conaxgames.libraries.config.core.model.CoreProcessorDenial;
import com.conaxgames.libraries.hooks.HookType;
import com.conaxgames.libraries.util.CC;
import com.conaxgames.libraries.util.Formatter;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CoreButtonProcessor {
    public final CoreMenu menu;
    public final ConfigButtonData data;
    public final Player player;

    public CoreProcessorDenial conditions() {
        List<String> conditions = this.data.getConditions();
        AtomicReference<Object> denial = new AtomicReference<Object>(null);
        conditions.forEach(condition -> {
            String[] split = condition.split(" ");
            String type = split[0];
            switch (type.toUpperCase()) {
                case "STRING_CONTAINS": {
                    if (split.length != 3) break;
                    String input = this.applyPlaceholders(this.player, null, split[1]);
                    String value = split[2];
                    if (input == null || value == null || !input.contains(value)) break;
                    denial.set(new CoreProcessorDenial(CC.RED + input + " did not contain " + value + "..."));
                    break;
                }
                case "STRING_EQUALS": {
                    if (split.length != 3) break;
                    String input = this.applyPlaceholders(this.player, null, split[1]);
                    String value = split[2];
                    if (input == null || !input.equals(value)) break;
                    denial.set(new CoreProcessorDenial(CC.RED + input + " did not equal " + value + "..."));
                    break;
                }
                case "STRING_EQUALS_IGNORECASE": {
                    if (split.length != 3) break;
                    String input = this.applyPlaceholders(this.player, null, split[1]);
                    String value = split[2];
                    if (input == null || !input.equalsIgnoreCase(value)) break;
                    denial.set(new CoreProcessorDenial(CC.RED + input + " did not equal " + value + "..."));
                    break;
                }
                case "STRING_DOES_NOT_CONTAIN": {
                    if (split.length != 3) break;
                    String input = this.applyPlaceholders(this.player, null, split[1]);
                    String value = split[2];
                    if (input == null || value == null || input.contains(value)) break;
                    denial.set(new CoreProcessorDenial(CC.RED + input + " contained " + value + "..."));
                    break;
                }
                case "STRING_DOES_NOT_EQUAL": {
                    if (split.length != 3) break;
                    String input = this.applyPlaceholders(this.player, null, split[1]);
                    String value = split[2];
                    if (input == null || input.equals(value)) break;
                    denial.set(new CoreProcessorDenial(CC.RED + input + " equalled " + value + "..."));
                    break;
                }
                case "STRING_DOES_NOT_EQUAL_IGNORECASE": {
                    if (split.length != 3) break;
                    String input = this.applyPlaceholders(this.player, null, split[1]);
                    String value = split[2];
                    if (input == null || input.equalsIgnoreCase(value)) break;
                    denial.set(new CoreProcessorDenial(CC.RED + input + " equalled " + value + "..."));
                    break;
                }
                case "LOGIC": {
                    double res;
                    double in;
                    if (split.length != 4) break;
                    String inputValue = this.parsePAPI(this.player, split[1]);
                    String operator = split[2];
                    String requiredValue = split[3];
                    try {
                        in = Double.parseDouble(inputValue);
                    }
                    catch (NumberFormatException exception) {
                        denial.set(new CoreProcessorDenial(CC.YELLOW + inputValue + CC.RED + " is not a valid number..."));
                        break;
                    }
                    try {
                        res = Double.parseDouble(requiredValue);
                    }
                    catch (NumberFormatException exception) {
                        denial.set(new CoreProcessorDenial(CC.YELLOW + requiredValue + CC.RED + " is not a valid number..."));
                        break;
                    }
                    String niceInputValue = Formatter.commaFormatInteger((int)in);
                    String niceRequiredValue = Formatter.commaFormatInteger((int)res);
                    switch (operator) {
                        case "GREATER_THAN": {
                            if (in > res) {
                                denial.set(new CoreProcessorDenial(CC.RED + "You have " + CC.YELLOW + niceInputValue + "/" + niceRequiredValue + CC.RED + "..."));
                            }
                        }
                        case "GREATER_THAN_EQUAL_TO": {
                            if (in >= res) {
                                denial.set(new CoreProcessorDenial(CC.RED + "You have " + CC.YELLOW + niceInputValue + "/" + niceRequiredValue + CC.RED + "..."));
                            }
                        }
                        case "EQUAL_TO": {
                            if (in == res) {
                                denial.set(new CoreProcessorDenial(CC.RED + "You need " + CC.YELLOW + niceRequiredValue + " but have " + niceInputValue + CC.RED + "..."));
                            }
                        }
                        case "NOT_EQUAL_TO": {
                            if (in != res) {
                                denial.set(new CoreProcessorDenial(CC.RED + "You need " + CC.YELLOW + niceRequiredValue + " but have " + niceInputValue + CC.RED + "..."));
                            }
                        }
                        case "LESS_THAN_EQUAL_TO": {
                            if (in <= res) {
                                denial.set(new CoreProcessorDenial(CC.RED + "You have " + CC.YELLOW + niceInputValue + "/" + niceRequiredValue + CC.RED + "..."));
                            }
                        }
                        case "LESS_THAN": {
                            if (!(in < res)) break;
                            denial.set(new CoreProcessorDenial(CC.RED + "You have " + CC.YELLOW + niceInputValue + "/" + niceRequiredValue + CC.RED + "..."));
                        }
                    }
                    break;
                }
                case "PERMISSION": {
                    String permissionValue;
                    if (split.length != 2 || (permissionValue = split[1]) == null || this.player.hasPermission(permissionValue)) break;
                    denial.set(new CoreProcessorDenial(CC.RED + "You required the " + CC.YELLOW + permissionValue + CC.RED + " permission..."));
                    break;
                }
                case "EMPTY_INVENTORY": {
                    if (!type.equalsIgnoreCase("EMPTY_INVENTORY") || this.player.getInventory().isEmpty()) break;
                    denial.set(new CoreProcessorDenial(CC.RED + "You need an empty inventory to use this..."));
                }
            }
        });
        return denial.get();
    }

    public void execute() {
        if (this.player == null || !this.player.isOnline()) {
            return;
        }
        this.data.getActions().forEach(action -> {
            String converted;
            if (action.equalsIgnoreCase("CLOSE")) {
                this.player.closeInventory();
            }
            if (action.startsWith("OPEN:")) {
                String name = this.applyPlaceholders(this.player, "OPEN:", (String)action);
                ConfigMenuData data = this.menu.getMenuByName(name.trim());
                if (data != null) {
                    this.menu.openMenu(this.player, data);
                } else {
                    this.player.sendMessage(CC.RED + "The " + CC.YELLOW + name + CC.RED + " menu could not be found...");
                    this.player.sendMessage(CC.RED + "Available menus: " + CC.YELLOW + this.menu.getMenuNames());
                }
            }
            if (action.startsWith("MESSAGE:")) {
                converted = this.applyPlaceholders(this.player, "MESSAGE:", (String)action);
                this.player.sendMessage(converted);
            }
            if (action.startsWith("BROADCAST:")) {
                converted = this.applyPlaceholders(this.player, "BROADCAST:", (String)action);
                Bukkit.broadcastMessage((String)converted);
            }
            if (action.startsWith("PLAYER:/")) {
                converted = this.applyPlaceholders(this.player, "PLAYER:/", (String)action);
                this.player.performCommand(converted);
            }
            if (action.startsWith("CONSOLE:/")) {
                converted = this.applyPlaceholders(this.player, "CONSOLE:/", (String)action);
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)converted);
            }
        });
    }

    public String applyPlaceholders(Player player, String prefix, String action) {
        if (prefix != null) {
            action = action.replaceFirst(prefix, "");
        }
        action = this.parsePAPI(player, action);
        action = CC.translate(action);
        action = action.replace("%player%", player.getName());
        action = action.replace("%PLAYER%", player.getName());
        action = action.replace("%player_display%", player.getDisplayName());
        action = action.replace("%PLAYER_DISPLAY%", player.getDisplayName());
        return action;
    }

    public String parsePAPI(Player player, String string) {
        if (LibraryPlugin.getInstance().getHookManager().isHooked(HookType.PLACEHOLDERAPI)) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)string.trim());
        }
        return string;
    }

    @Generated
    public CoreButtonProcessor(CoreMenu menu, ConfigButtonData data, Player player) {
        this.menu = menu;
        this.data = data;
        this.player = player;
    }
}

