/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.config.core.model;

import com.conaxgames.libraries.LibraryPlugin;
import com.conaxgames.libraries.hooks.HookType;
import com.conaxgames.libraries.message.FormatUtil;
import com.conaxgames.libraries.util.CC;
import com.conaxgames.libraries.util.ItemBuilderUtil;
import com.conaxgames.libraries.xseries.XMaterial;
import java.util.List;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public class ConfigButtonData {
    public final List<String> actions;
    public final List<String> conditions;
    public final String name;
    public final String permission;
    public final int slot;
    public final XMaterial material;
    public final int materialData;
    public final boolean shiny;
    public final List<String> lore;
    public String skull64 = null;

    public void setSkull64(String skull) {
        this.skull64 = skull;
    }

    public ItemBuilderUtil getItemBuilder(Player player) {
        ItemBuilderUtil builder = new ItemBuilderUtil(this.material.parseMaterial());
        builder.setName(CC.translate(this.name));
        builder.setDurability((short)this.materialData);
        this.lore.forEach(s -> {
            String translated = s;
            if (LibraryPlugin.getInstance().getHookManager().isHooked(HookType.PLACEHOLDERAPI)) {
                translated = PlaceholderAPI.setPlaceholders((Player)player, (String)translated);
            }
            builder.addLoreLineList(FormatUtil.wordWrap(CC.translate(translated)));
        });
        if (this.getMaterial().equals((Object)XMaterial.PLAYER_HEAD) && this.skull64 != null) {
            builder.setSkullProfile(this.skull64);
        }
        return builder;
    }

    public boolean hasAction() {
        return this.actions != null;
    }

    public boolean hasCondition() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasPermission(Player player) {
        if (this.permission == null) {
            return true;
        }
        return player.hasPermission(this.permission);
    }

    @Generated
    public List<String> getActions() {
        return this.actions;
    }

    @Generated
    public List<String> getConditions() {
        return this.conditions;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public int getSlot() {
        return this.slot;
    }

    @Generated
    public XMaterial getMaterial() {
        return this.material;
    }

    @Generated
    public int getMaterialData() {
        return this.materialData;
    }

    @Generated
    public boolean isShiny() {
        return this.shiny;
    }

    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @Generated
    public String getSkull64() {
        return this.skull64;
    }

    @Generated
    public ConfigButtonData(List<String> actions, List<String> conditions, String name, String permission, int slot, XMaterial material, int materialData, boolean shiny, List<String> lore) {
        this.actions = actions;
        this.conditions = conditions;
        this.name = name;
        this.permission = permission;
        this.slot = slot;
        this.material = material;
        this.materialData = materialData;
        this.shiny = shiny;
        this.lore = lore;
    }
}

