/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.commands;

import com.conaxgames.libraries.LibraryPlugin;
import com.conaxgames.libraries.acf.InvalidCommandArgument;
import com.conaxgames.libraries.acf.PaperCommandManager;
import com.conaxgames.libraries.commands.CommandMessages;
import com.conaxgames.libraries.commands.impl.LibraryCommands;
import com.conaxgames.libraries.module.type.Module;
import com.conaxgames.libraries.util.EnchantmentProcessor;
import com.conaxgames.libraries.util.PotionProcessor;
import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class CommandRegistry {
    public CommandRegistry(LibraryPlugin libraryPlugin, PaperCommandManager commandManager) {
        new CommandMessages(commandManager);
        commandManager.enableUnstableAPI("help");
        this.loadContexts(libraryPlugin, commandManager);
        this.loadCompletions(libraryPlugin, commandManager);
        commandManager.registerCommand(new LibraryCommands());
    }

    public void loadContexts(LibraryPlugin libraryPlugin, PaperCommandManager commandManager) {
        commandManager.getCommandContexts().registerContext(Plugin.class, c -> {
            String argument = c.popFirstArg();
            Plugin plugin = Bukkit.getPluginManager().getPlugin(argument);
            if (plugin != null) {
                return plugin;
            }
            throw new InvalidCommandArgument("No plugin matching " + argument + " could be found.");
        });
        commandManager.getCommandContexts().registerContext(ItemStack.class, c -> {
            String argument = c.popFirstArg();
            Material material = Material.getMaterial((String)argument);
            if (material != null) {
                return new ItemStack(material);
            }
            throw new InvalidCommandArgument("No item matching " + argument + " could be found.");
        });
        commandManager.getCommandContexts().registerContext(Enchantment.class, c -> {
            String argument = c.popFirstArg();
            Enchantment enchantment = Enchantment.getByName((String)EnchantmentProcessor.process(argument.toUpperCase()));
            if (enchantment != null) {
                return enchantment;
            }
            throw new InvalidCommandArgument("No enchantment matching " + argument + " could be found.");
        });
        commandManager.getCommandContexts().registerContext(PotionEffectType.class, c -> {
            String argument = c.popFirstArg();
            PotionEffectType effectType = PotionEffectType.getByName((String)PotionProcessor.process(argument.toUpperCase()));
            if (effectType != null) {
                return effectType;
            }
            throw new InvalidCommandArgument("No potion effect matching " + argument + " could be found.");
        });
        commandManager.getCommandContexts().registerContext(Module.class, c -> {
            String argument = c.popFirstArg();
            Module module = libraryPlugin.getModuleManager().getModuleByIdentifier(argument);
            if (module == null) {
                throw new InvalidCommandArgument("No module matching " + argument + " could be found.");
            }
            return module;
        });
    }

    public void loadCompletions(LibraryPlugin libraryPlugin, PaperCommandManager commandManager) {
        commandManager.getCommandCompletions().registerAsyncCompletion("plugins", c -> {
            ArrayList<String> values = new ArrayList<String>();
            for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                values.add(plugin.getName().toLowerCase(Locale.ENGLISH));
            }
            return values;
        });
        commandManager.getCommandCompletions().registerAsyncCompletion("materials", c -> {
            ArrayList<String> values = new ArrayList<String>();
            for (Material material : Material.values()) {
                values.add(material.name());
            }
            return values;
        });
        commandManager.getCommandCompletions().registerAsyncCompletion("enchantments", c -> EnchantmentProcessor.enchantmentmap.keySet());
        commandManager.getCommandCompletions().registerAsyncCompletion("modules", c -> libraryPlugin.getModuleManager().getModules().keySet().stream().map(String::toLowerCase).collect(Collectors.toList()));
    }
}

