/*
 * Decompiled with CFR 0.152.
 */
package com.conaxgames.libraries.board;

import com.conaxgames.libraries.board.Board;
import java.text.DecimalFormat;
import org.apache.commons.lang.time.DurationFormatUtils;

public class BoardTimer {
    private static final DecimalFormat SECONDS_FORMATTER = new DecimalFormat("#0.0");
    private final Board board;
    private final String id;
    private final double duration;
    private final long end;

    public BoardTimer(Board board, String id, double duration) {
        this.board = board;
        this.id = id;
        this.duration = duration;
        this.end = (long)((double)System.currentTimeMillis() + duration * 1000.0);
        if (board != null) {
            board.getTimers().add(this);
        }
    }

    public String getFormattedString(TimerType format) {
        if (format == TimerType.SECONDS) {
            return SECONDS_FORMATTER.format((float)(this.end - System.currentTimeMillis()) / 1000.0f);
        }
        return DurationFormatUtils.formatDuration((long)(this.end - System.currentTimeMillis()), (String)"mm:ss");
    }

    public void cancel() {
        if (this.board != null) {
            this.board.getTimers().remove(this);
        }
    }

    public Board getBoard() {
        return this.board;
    }

    public String getId() {
        return this.id;
    }

    public double getDuration() {
        return this.duration;
    }

    public long getEnd() {
        return this.end;
    }

    public static enum TimerType {
        SECONDS,
        MINUTES,
        HOURS;

    }
}

